/*
 * Decompiled with CFR 0.152.
 */
package de.blackrose01;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.blackrose01.Parameters;
import de.blackrose01.Version;
import de.blackrose01.endpoint.Endpoint;
import de.blackrose01.endpoint.EndpointPrivate;
import de.blackrose01.endpoint.EndpointPublic;
import de.blackrose01.model.AlternativeName;
import de.blackrose01.model.ApiStatus;
import de.blackrose01.model.Artwork;
import de.blackrose01.model.Character;
import de.blackrose01.model.CharacterMugShot;
import de.blackrose01.model.Collection;
import de.blackrose01.model.Cover;
import de.blackrose01.model.ExternalGame;
import de.blackrose01.model.Feed;
import de.blackrose01.model.Franchise;
import de.blackrose01.model.Genre;
import de.blackrose01.model.InvolvedCompany;
import de.blackrose01.model.Keyword;
import de.blackrose01.model.MultiplayerMode;
import de.blackrose01.model.PlayerPerspective;
import de.blackrose01.model.ProductFamily;
import de.blackrose01.model.ReleaseDate;
import de.blackrose01.model.Screenshot;
import de.blackrose01.model.Search;
import de.blackrose01.model.Theme;
import de.blackrose01.model.TimeToBeat;
import de.blackrose01.model.Title;
import de.blackrose01.model.Website;
import de.blackrose01.model.achievement.Achievement;
import de.blackrose01.model.achievement.AchievementIcon;
import de.blackrose01.model.agerating.AgeRating;
import de.blackrose01.model.agerating.AgeRatingContentDescription;
import de.blackrose01.model.company.Company;
import de.blackrose01.model.company.CompanyLogo;
import de.blackrose01.model.company.CompanyWebsite;
import de.blackrose01.model.game.Game;
import de.blackrose01.model.game.GameEngine;
import de.blackrose01.model.game.GameEngineLogo;
import de.blackrose01.model.game.GameMode;
import de.blackrose01.model.game.GameVersion;
import de.blackrose01.model.game.GameVersionFeature;
import de.blackrose01.model.game.GameVersionFeatureValue;
import de.blackrose01.model.game.GameVideo;
import de.blackrose01.model.page.Page;
import de.blackrose01.model.page.PageBackground;
import de.blackrose01.model.page.PageLogo;
import de.blackrose01.model.page.PageWebsite;
import de.blackrose01.model.platform.Platform;
import de.blackrose01.model.platform.PlatformLogo;
import de.blackrose01.model.platform.PlatformVersion;
import de.blackrose01.model.platform.PlatformVersionCompany;
import de.blackrose01.model.platform.PlatformVersionReleaseDate;
import de.blackrose01.model.platform.PlatformWebsite;
import de.blackrose01.model.privates.FeedFollow;
import de.blackrose01.model.privates.Follow;
import de.blackrose01.model.privates.ListEntry;
import de.blackrose01.model.privates.People;
import de.blackrose01.model.privates.Rate;
import de.blackrose01.model.privates.Review;
import de.blackrose01.model.privates.ReviewVideo;
import de.blackrose01.model.pulse.Pulse;
import de.blackrose01.model.pulse.PulseGroup;
import de.blackrose01.model.pulse.PulseImage;
import de.blackrose01.model.pulse.PulseSource;
import de.blackrose01.model.pulse.PulseUrl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class IgdbWrapper {
    private String apiKey;
    private String urlBase;

    public IgdbWrapper(String apiKey, String urlBase) {
        this(apiKey, urlBase, Version.Standard);
    }

    public IgdbWrapper(String apiKey, String urlBase, Version version) {
        this.apiKey = apiKey;
        this.urlBase = urlBase;
        if (!urlBase.endsWith("/")) {
            this.urlBase = this.urlBase + "/";
        }
        if (version == Version.Pro) {
            this.urlBase = this.urlBase + "pro/";
        }
    }

    public <T> List<T> sendRequest(Endpoint endpoint, Parameters parameters, HttpMethod httpMethod, Class<?> c) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        ArrayList newData = new ArrayList();
        if (parameters == null) {
            parameters = new Parameters();
        }
        headers.add("user-key", this.apiKey);
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        HttpEntity entity = new HttpEntity((Object)parameters.buildQuery(), (MultiValueMap)headers);
        Object[] data = (Object[])restTemplate.exchange(this.urlBase + endpoint.getUri(), httpMethod, entity, Object[].class, new Object[0]).getBody();
        Arrays.stream(data).forEach(o -> newData.add(new ObjectMapper().convertValue(o, c)));
        return newData;
    }

    public <T> List<T> sendRequest(Endpoint endpoint, Parameters parameters, Class<T> c) {
        return this.sendRequest(endpoint, parameters, HttpMethod.GET, c);
    }

    public <T> List<T> sendRequest(Endpoint endpoint, HttpMethod httpMethod, Class<T> c) {
        return this.sendRequest(endpoint, new Parameters(), httpMethod, c);
    }

    public <T> List<T> sendRequest(Endpoint endpoint, Class<T> c) {
        return this.sendRequest(endpoint, new Parameters(), HttpMethod.GET, c);
    }

    public List<Achievement> getAchievements(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Achievement, parameters, HttpMethod.POST, Achievement.class);
    }

    public List<AchievementIcon> getAchievementIcons(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Achievement_Icon, parameters, HttpMethod.POST, AchievementIcon.class);
    }

    public List<AgeRating> getAgeRatings(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Age_Rating, parameters, HttpMethod.POST, AgeRating.class);
    }

    public List<AgeRatingContentDescription> getAgeRatingContentDescriptions(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Age_Rating_Content_Description, parameters, HttpMethod.POST, AgeRatingContentDescription.class);
    }

    public List<AlternativeName> getAlternativeNames(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Alternative_Name, parameters, HttpMethod.POST, AlternativeName.class);
    }

    public List<ApiStatus> getApiStatuss(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Api_Status, parameters, HttpMethod.POST, ApiStatus.class);
    }

    public List<Artwork> getArtworks(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Artwork, parameters, HttpMethod.POST, Artwork.class);
    }

    public List<Character> getCharacters(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Character, parameters, HttpMethod.POST, Character.class);
    }

    public List<CharacterMugShot> getCharacterMugShots(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Character_Mug_Shot, parameters, HttpMethod.POST, CharacterMugShot.class);
    }

    public List<Collection> getCollections(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Collection, parameters, HttpMethod.POST, Collection.class);
    }

    public List<Company> getCompanys(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Company, parameters, HttpMethod.POST, Company.class);
    }

    public List<CompanyLogo> getCompanyLogos(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Company_Logo, parameters, HttpMethod.POST, CompanyLogo.class);
    }

    public List<CompanyWebsite> getCompanyWebsites(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Company_Website, parameters, HttpMethod.POST, CompanyWebsite.class);
    }

    public List<Cover> getCovers(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Cover, parameters, HttpMethod.POST, Cover.class);
    }

    public List<ExternalGame> getExternalGames(Parameters parameters) {
        return this.sendRequest(EndpointPublic.External_Games, parameters, HttpMethod.POST, ExternalGame.class);
    }

    public List<Feed> getFeeds(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Feed, parameters, HttpMethod.POST, Feed.class);
    }

    public List<Franchise> getFranchises(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Franchise, parameters, HttpMethod.POST, Franchise.class);
    }

    public List<Game> getGames(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Game, parameters, HttpMethod.POST, Game.class);
    }

    public List<GameEngine> getGameEngines(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Game_Engine, parameters, HttpMethod.POST, GameEngine.class);
    }

    public List<GameEngineLogo> getGameEngineLogos(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Game_Engine_Logo, parameters, HttpMethod.POST, GameEngineLogo.class);
    }

    public List<GameMode> getGameModes(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Game_Mode, parameters, HttpMethod.POST, GameMode.class);
    }

    public List<GameVersion> getGameVersions(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Game_Version, parameters, HttpMethod.POST, GameVersion.class);
    }

    public List<GameVersionFeature> getGameVersionFeatures(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Game_Version_Feature, parameters, HttpMethod.POST, GameVersionFeature.class);
    }

    public List<GameVersionFeatureValue> getGameVersionFeatureValues(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Game_Version_Feature_Value, parameters, HttpMethod.POST, GameVersionFeatureValue.class);
    }

    public List<GameVideo> getGameVideos(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Game_Video, parameters, HttpMethod.POST, GameVideo.class);
    }

    public List<Genre> getGenres(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Genre, parameters, HttpMethod.POST, Genre.class);
    }

    public List<InvolvedCompany> getInvolvedCompanys(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Involved_Company, parameters, HttpMethod.POST, InvolvedCompany.class);
    }

    public List<Keyword> getKeywords(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Keyword, parameters, HttpMethod.POST, Keyword.class);
    }

    public List<MultiplayerMode> getMultiplayerModes(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Multiplayer_Mode, parameters, HttpMethod.POST, MultiplayerMode.class);
    }

    public List<Page> getPages(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Page, parameters, HttpMethod.POST, Page.class);
    }

    public List<PageBackground> getPageBackgrounds(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Page_Background, parameters, HttpMethod.POST, PageBackground.class);
    }

    public List<PageLogo> getPageLogos(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Page_Logo, parameters, HttpMethod.POST, PageLogo.class);
    }

    public List<PageWebsite> getPageWebsites(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Page_Website, parameters, HttpMethod.POST, PageWebsite.class);
    }

    public List<Platform> getPlatforms(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Platform, parameters, HttpMethod.POST, Platform.class);
    }

    public List<PlatformLogo> getPlatformLogos(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Platform_Logo, parameters, HttpMethod.POST, PlatformLogo.class);
    }

    public List<PlatformVersion> getPlatformVersions(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Platform_Version, parameters, HttpMethod.POST, PlatformVersion.class);
    }

    public List<PlatformVersionCompany> getPlatformVersionCompanys(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Platform_Version_Company, parameters, HttpMethod.POST, PlatformVersionCompany.class);
    }

    public List<PlatformVersionReleaseDate> getPlatformVersionReleaseDates(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Platform_Version_Release_Date, parameters, HttpMethod.POST, PlatformVersionReleaseDate.class);
    }

    public List<PlatformWebsite> getPlatformWebsites(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Platform_Website, parameters, HttpMethod.POST, PlatformWebsite.class);
    }

    public List<PlayerPerspective> getPlayerPerspectives(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Player_Perspective, parameters, HttpMethod.POST, PlayerPerspective.class);
    }

    public List<FeedFollow> getFeedFollows(Parameters parameters) {
        return this.sendRequest(EndpointPrivate.Feed_Follow, parameters, HttpMethod.POST, FeedFollow.class);
    }

    public List<Follow> getFollows(Parameters parameters) {
        return this.sendRequest(EndpointPrivate.Follow, parameters, HttpMethod.POST, Follow.class);
    }

    public List<List> getLists(Parameters parameters) {
        return this.sendRequest(EndpointPrivate.List, parameters, HttpMethod.POST, List.class);
    }

    public List<ListEntry> getListEntrys(Parameters parameters) {
        return this.sendRequest(EndpointPrivate.List_Entry, parameters, HttpMethod.POST, ListEntry.class);
    }

    public List<People> getPeoples(Parameters parameters) {
        return this.sendRequest(EndpointPrivate.People, parameters, HttpMethod.POST, People.class);
    }

    public List<Rate> getRates(Parameters parameters) {
        return this.sendRequest(EndpointPrivate.Rate, parameters, HttpMethod.POST, Rate.class);
    }

    public List<Review> getReviews(Parameters parameters) {
        return this.sendRequest(EndpointPrivate.Review, parameters, HttpMethod.POST, Review.class);
    }

    public List<ReviewVideo> getReviewVideos(Parameters parameters) {
        return this.sendRequest(EndpointPrivate.Review_Video, parameters, HttpMethod.POST, ReviewVideo.class);
    }

    public List<ProductFamily> getProductFamilys(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Product_Family, parameters, HttpMethod.POST, ProductFamily.class);
    }

    public List<Pulse> getPulses(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Pulse, parameters, HttpMethod.POST, Pulse.class);
    }

    public List<PulseGroup> getPulseGroups(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Pulse_Group, parameters, HttpMethod.POST, PulseGroup.class);
    }

    public List<PulseImage> getPulseImages(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Pulse_Image, parameters, HttpMethod.POST, PulseImage.class);
    }

    public List<PulseSource> getPulseSources(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Pulse_Source, parameters, HttpMethod.POST, PulseSource.class);
    }

    public List<PulseUrl> getPulseUrls(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Pulse_Url, parameters, HttpMethod.POST, PulseUrl.class);
    }

    public List<ReleaseDate> getReleaseDates(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Release_Date, parameters, HttpMethod.POST, ReleaseDate.class);
    }

    public List<Screenshot> getScreenshots(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Screenshot, parameters, HttpMethod.POST, Screenshot.class);
    }

    public List<Search> getSearchs(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Search, parameters, HttpMethod.POST, Search.class);
    }

    public List<Theme> getThemes(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Theme, parameters, HttpMethod.POST, Theme.class);
    }

    public List<TimeToBeat> getTimeToBeats(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Time_to_Beat, parameters, HttpMethod.POST, TimeToBeat.class);
    }

    public List<Title> getTitles(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Title, parameters, HttpMethod.POST, Title.class);
    }

    public List<Website> getWebsites(Parameters parameters) {
        return this.sendRequest(EndpointPublic.Website, parameters, HttpMethod.POST, Website.class);
    }
}

