/*
 * Decompiled with CFR 0.152.
 */
package de.blackrose01.model.game;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import de.blackrose01.model.Artwork;
import de.blackrose01.model.Collection;
import de.blackrose01.model.Cover;
import de.blackrose01.model.ExternalGame;
import de.blackrose01.model.Franchise;
import de.blackrose01.model.Genre;
import de.blackrose01.model.InvolvedCompany;
import de.blackrose01.model.Keyword;
import de.blackrose01.model.MultiplayerMode;
import de.blackrose01.model.PlayerPerspective;
import de.blackrose01.model.ReleaseDate;
import de.blackrose01.model.Screenshot;
import de.blackrose01.model.Theme;
import de.blackrose01.model.TimeToBeat;
import de.blackrose01.model.Website;
import de.blackrose01.model.agerating.AgeRating;
import de.blackrose01.model.game.GameEngine;
import de.blackrose01.model.game.GameMode;
import de.blackrose01.model.game.GameVideo;
import de.blackrose01.model.platform.Platform;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Game
implements Serializable {
    @JsonIgnore
    @JsonProperty(value="id")
    private long id;
    @JsonIgnore
    @JsonProperty(value="category")
    private int category;
    @JsonIgnore
    @JsonProperty(value="status")
    private int status;
    @JsonIgnore
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="collection")
    private Object collection;
    @JsonProperty(value="cover")
    private Object cover;
    @JsonIgnore
    @JsonProperty(value="storyline")
    private String storyline;
    @JsonProperty(value="external_games")
    private List<Object> externalGames;
    @JsonProperty(value="first_release_date")
    private Object firstReleaseDate;
    @JsonProperty(value="game_modes")
    private List<Object> gameModes;
    @JsonProperty(value="keywords")
    private List<Object> keywords;
    @JsonProperty(value="platforms")
    private List<Object> platforms;
    @JsonIgnore
    @JsonProperty(value="popularity")
    private double popularity;
    @JsonIgnore
    @JsonProperty(value="pulse_count")
    private int pulseCount;
    @JsonProperty(value="release_dates")
    private List<Object> releaseDates;
    @JsonProperty(value="similar_games")
    private List<Object> gamesSimilar;
    @JsonIgnore
    @JsonProperty(value="slug")
    private String slug;
    @JsonIgnore
    @JsonProperty(value="summary")
    private String summary;
    @JsonIgnore
    @JsonProperty(value="tags")
    private List<Long> tags;
    @JsonProperty(value="themes")
    private List<Object> themes;
    @JsonIgnore
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="videos")
    private List<Object> videos;
    @JsonProperty(value="websites")
    private List<Object> websites;
    @JsonIgnore
    @JsonProperty(value="parent_game")
    private long gameParent;
    @JsonProperty(value="age_ratings")
    private List<Object> ratingsAge;
    @JsonIgnore
    @JsonProperty(value="rating")
    private double rating;
    @JsonIgnore
    @JsonProperty(value="rating_count")
    private int ratingCount;
    @JsonProperty(value="screenshots")
    private List<Object> screenshots;
    @JsonProperty(value="multiplayer_modes")
    private List<Object> modesMultiplayer;
    @JsonProperty(value="involved_companies")
    private List<Object> companiesInvolved;
    @JsonProperty(value="genres")
    private List<Object> genres;
    @JsonProperty(value="game_engines")
    private List<Object> gameEngines;
    @JsonProperty(value="franchises")
    private List<Object> franchises;
    @JsonProperty(value="artworks")
    private List<Object> artworks;
    @JsonProperty(value="bundles")
    private List<Object> bundles;
    @JsonProperty(value="franchise")
    private Object franchise;
    @JsonIgnore
    @JsonProperty(value="hypes")
    private int hypes;
    @JsonIgnore
    @JsonProperty(value="follows")
    private int follows;
    @JsonProperty(value="time_to_beat")
    private Object timeToBeat;
    @JsonProperty(value="expansions")
    private List<Object> expansions;
    @JsonProperty(value="standalone_expansions")
    private List<Object> expansionsStandalone;
    @JsonProperty(value="dlcs")
    private List<Object> dlcs;
    @JsonProperty(value="player_perspectives")
    private List<Object> perspectivesPlayer;
    @JsonIgnore
    @JsonProperty(value="total_rating")
    private double ratingTotal;
    @JsonIgnore
    @JsonProperty(value="total_rating_count")
    private int ratingTotalCount;
    @JsonProperty(value="parent_game")
    private Object parentVersion;
    @JsonIgnore
    @JsonProperty(value="version_title")
    private String titleVersion;
    @JsonIgnore
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonIgnore
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonIgnore
    @JsonProperty(value="checksum")
    private String checksum;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCollection() {
        return Long.parseLong(String.valueOf(this.collection));
    }

    public Collection getCollectionObject() {
        return (Collection)new ObjectMapper().convertValue(this.collection, Collection.class);
    }

    public void setCollection(Object collection) {
        this.collection = collection;
    }

    public Long getCover() {
        return Long.parseLong(String.valueOf(this.cover));
    }

    public Cover getCoverObject() {
        return (Cover)new ObjectMapper().convertValue(this.cover, Cover.class);
    }

    public void setCover(Object cover) {
        this.cover = cover;
    }

    public String getStoryline() {
        return this.storyline;
    }

    public void setStoryline(String storyline) {
        this.storyline = storyline;
    }

    public List<Long> getExternalGames() {
        return (List)new ObjectMapper().convertValue(this.externalGames, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<ExternalGame> getExternalGamesObject() {
        return (List)new ObjectMapper().convertValue(this.externalGames, (TypeReference)new TypeReference<List<ExternalGame>>(){});
    }

    public void setExternalGames(List<Object> externalGames) {
        this.externalGames = externalGames;
    }

    public Object getFirstReleaseDate() {
        return this.firstReleaseDate;
    }

    public void setFirstReleaseDate(Object firstReleaseDate) {
        this.firstReleaseDate = firstReleaseDate;
    }

    public List<Long> getGameModes() {
        return (List)new ObjectMapper().convertValue(this.gameModes, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<GameMode> getGameModesObject() {
        return (List)new ObjectMapper().convertValue(this.gameModes, (TypeReference)new TypeReference<List<GameMode>>(){});
    }

    public void setGameModes(List<Object> gameModes) {
        this.gameModes = gameModes;
    }

    public List<Long> getKeywords() {
        return (List)new ObjectMapper().convertValue(this.keywords, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Keyword> getKeywordsObject() {
        return (List)new ObjectMapper().convertValue(this.keywords, (TypeReference)new TypeReference<List<Keyword>>(){});
    }

    public void setKeywords(List<Object> keywords) {
        this.keywords = keywords;
    }

    public List<Long> getPlatforms() {
        return (List)new ObjectMapper().convertValue(this.platforms, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Platform> getPlatformsObject() {
        return (List)new ObjectMapper().convertValue(this.platforms, (TypeReference)new TypeReference<List<Platform>>(){});
    }

    public void setPlatforms(List<Object> platforms) {
        this.platforms = platforms;
    }

    public double getPopularity() {
        return this.popularity;
    }

    public void setPopularity(double popularity) {
        this.popularity = popularity;
    }

    public int getPulseCount() {
        return this.pulseCount;
    }

    public void setPulseCount(int pulseCount) {
        this.pulseCount = pulseCount;
    }

    public List<Long> getReleaseDates() {
        return (List)new ObjectMapper().convertValue(this.releaseDates, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<ReleaseDate> getReleaseDatesObject() {
        return (List)new ObjectMapper().convertValue(this.releaseDates, (TypeReference)new TypeReference<List<ReleaseDate>>(){});
    }

    public void setReleaseDates(List<Object> releaseDates) {
        this.releaseDates = releaseDates;
    }

    public List<Long> getGamesSimilar() {
        return (List)new ObjectMapper().convertValue(this.gamesSimilar, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Game> getGamesSimilarObject() {
        return (List)new ObjectMapper().convertValue(this.gamesSimilar, (TypeReference)new TypeReference<List<Game>>(){});
    }

    public void setGamesSimilar(List<Object> gamesSimilar) {
        this.gamesSimilar = gamesSimilar;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public List<Long> getTags() {
        return this.tags;
    }

    public void setTags(List<Long> tags) {
        this.tags = tags;
    }

    public List<Long> getThemes() {
        return (List)new ObjectMapper().convertValue(this.themes, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Theme> getThemesObject() {
        return (List)new ObjectMapper().convertValue(this.themes, (TypeReference)new TypeReference<List<Theme>>(){});
    }

    public void setThemes(List<Object> themes) {
        this.themes = themes;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<Long> getVideos() {
        return (List)new ObjectMapper().convertValue(this.videos, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<GameVideo> getVideosObject() {
        return (List)new ObjectMapper().convertValue(this.videos, (TypeReference)new TypeReference<List<GameVideo>>(){});
    }

    public void setVideos(List<Object> videos) {
        this.videos = videos;
    }

    public List<Long> getWebsites() {
        return (List)new ObjectMapper().convertValue(this.websites, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Website> getWebsitesObject() {
        return (List)new ObjectMapper().convertValue(this.websites, (TypeReference)new TypeReference<List<Website>>(){});
    }

    public void setWebsites(List<Object> websites) {
        this.websites = websites;
    }

    public long getGameParent() {
        return this.gameParent;
    }

    public void setGameParent(long gameParent) {
        this.gameParent = gameParent;
    }

    public List<Long> getRatingsAge() {
        return (List)new ObjectMapper().convertValue(this.ratingsAge, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<AgeRating> getRatingsAgeObject() {
        return (List)new ObjectMapper().convertValue(this.ratingsAge, (TypeReference)new TypeReference<List<AgeRating>>(){});
    }

    public void setRatingsAge(List<Object> ratingsAge) {
        this.ratingsAge = ratingsAge;
    }

    public double getRating() {
        return this.rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public int getRatingCount() {
        return this.ratingCount;
    }

    public void setRatingCount(int ratingCount) {
        this.ratingCount = ratingCount;
    }

    public List<Long> getScreenshots() {
        return (List)new ObjectMapper().convertValue(this.screenshots, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Screenshot> getScreenshotsObject() {
        return (List)new ObjectMapper().convertValue(this.screenshots, (TypeReference)new TypeReference<List<Screenshot>>(){});
    }

    public void setScreenshots(List<Object> screenshots) {
        this.screenshots = screenshots;
    }

    public List<Long> getModesMultiplayer() {
        return (List)new ObjectMapper().convertValue(this.modesMultiplayer, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<MultiplayerMode> getModesMultiplayerObject() {
        return (List)new ObjectMapper().convertValue(this.modesMultiplayer, (TypeReference)new TypeReference<List<MultiplayerMode>>(){});
    }

    public void setModesMultiplayer(List<Object> modesMultiplayer) {
        this.modesMultiplayer = modesMultiplayer;
    }

    public List<Long> getCompaniesInvolved() {
        return (List)new ObjectMapper().convertValue(this.companiesInvolved, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<InvolvedCompany> getCompaniesInvolvedObject() {
        return (List)new ObjectMapper().convertValue(this.companiesInvolved, (TypeReference)new TypeReference<List<InvolvedCompany>>(){});
    }

    public void setCompaniesInvolved(List<Object> companiesInvolved) {
        this.companiesInvolved = companiesInvolved;
    }

    public List<Long> getGenres() {
        return (List)new ObjectMapper().convertValue(this.genres, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Genre> getGenresObject() {
        return (List)new ObjectMapper().convertValue(this.genres, (TypeReference)new TypeReference<List<Genre>>(){});
    }

    public void setGenres(List<Object> genres) {
        this.genres = genres;
    }

    public List<Long> getGameEngines() {
        return (List)new ObjectMapper().convertValue(this.gameEngines, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<GameEngine> getGameEnginesObject() {
        return (List)new ObjectMapper().convertValue(this.gameEngines, (TypeReference)new TypeReference<List<GameEngine>>(){});
    }

    public void setGameEngines(List<Object> gameEngines) {
        this.gameEngines = gameEngines;
    }

    public List<Long> getFranchises() {
        return (List)new ObjectMapper().convertValue(this.franchises, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Franchise> getFranchisesObject() {
        return (List)new ObjectMapper().convertValue(this.franchises, (TypeReference)new TypeReference<List<Franchise>>(){});
    }

    public void setFranchises(List<Object> franchises) {
        this.franchises = franchises;
    }

    public List<Long> getArtworks() {
        return (List)new ObjectMapper().convertValue(this.artworks, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Artwork> getArtworksObject() {
        return (List)new ObjectMapper().convertValue(this.artworks, (TypeReference)new TypeReference<List<Artwork>>(){});
    }

    public void setArtworks(List<Object> artworks) {
        this.artworks = artworks;
    }

    public List<Long> getBundles() {
        return (List)new ObjectMapper().convertValue(this.bundles, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Game> getBundlesObject() {
        return (List)new ObjectMapper().convertValue(this.bundles, (TypeReference)new TypeReference<List<Game>>(){});
    }

    public void setBundles(List<Object> bundles) {
        this.bundles = bundles;
    }

    public long getFranchise() {
        return Long.parseLong(String.valueOf(this.franchise));
    }

    public Franchise getFranchiseObject() {
        return (Franchise)new ObjectMapper().convertValue(this.franchise, Franchise.class);
    }

    public void setFranchise(Object franchise) {
        this.franchise = franchise;
    }

    public int getHypes() {
        return this.hypes;
    }

    public void setHypes(int hypes) {
        this.hypes = hypes;
    }

    public int getFollows() {
        return this.follows;
    }

    public void setFollows(int follows) {
        this.follows = follows;
    }

    public long getTimeToBeat() {
        return Long.parseLong(String.valueOf(this.timeToBeat));
    }

    public TimeToBeat getTimeToBeatObject() {
        return (TimeToBeat)new ObjectMapper().convertValue(this.franchise, TimeToBeat.class);
    }

    public void setTimeToBeat(Object timeToBeat) {
        this.timeToBeat = timeToBeat;
    }

    public List<Long> getExpansions() {
        return (List)new ObjectMapper().convertValue(this.expansions, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Game> getExpansionsObject() {
        return (List)new ObjectMapper().convertValue(this.expansions, (TypeReference)new TypeReference<List<Game>>(){});
    }

    public void setExpansions(List<Object> expansions) {
        this.expansions = expansions;
    }

    public List<Long> getExpansionsStandalone() {
        return (List)new ObjectMapper().convertValue(this.expansionsStandalone, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Game> getExpansionsStandaloneObject() {
        return (List)new ObjectMapper().convertValue(this.expansionsStandalone, (TypeReference)new TypeReference<List<Game>>(){});
    }

    public void setExpansionsStandalone(List<Object> expansionsStandalone) {
        this.expansionsStandalone = expansionsStandalone;
    }

    public List<Long> getDlcs() {
        return (List)new ObjectMapper().convertValue(this.dlcs, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<Game> getDlcsObject() {
        return (List)new ObjectMapper().convertValue(this.dlcs, (TypeReference)new TypeReference<List<Game>>(){});
    }

    public void setDlcs(List<Object> dlcs) {
        this.dlcs = dlcs;
    }

    public List<Long> getPerspectivesPlayer() {
        return (List)new ObjectMapper().convertValue(this.perspectivesPlayer, (TypeReference)new TypeReference<List<Long>>(){});
    }

    public List<PlayerPerspective> getPerspectivesPlayerObject() {
        return (List)new ObjectMapper().convertValue(this.perspectivesPlayer, (TypeReference)new TypeReference<List<PlayerPerspective>>(){});
    }

    public void setPerspectivesPlayer(List<Object> perspectivesPlayer) {
        this.perspectivesPlayer = perspectivesPlayer;
    }

    public double getRatingTotal() {
        return this.ratingTotal;
    }

    public void setRatingTotal(double ratingTotal) {
        this.ratingTotal = ratingTotal;
    }

    public int getRatingTotalCount() {
        return this.ratingTotalCount;
    }

    public void setRatingTotalCount(int ratingTotalCount) {
        this.ratingTotalCount = ratingTotalCount;
    }

    public long getParentVersion() {
        return Long.parseLong(String.valueOf(this.parentVersion));
    }

    public Game getParentVersionObject() {
        return (Game)new ObjectMapper().convertValue(this.parentVersion, Game.class);
    }

    public void setParentVersion(Object parentVersion) {
        this.parentVersion = parentVersion;
    }

    public String getTitleVersion() {
        return this.titleVersion;
    }

    public void setTitleVersion(String titleVersion) {
        this.titleVersion = titleVersion;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Game game = (Game)o;
        return this.id == game.id && this.category == game.category && this.status == game.status && Double.compare(game.popularity, this.popularity) == 0 && this.pulseCount == game.pulseCount && this.gameParent == game.gameParent && Double.compare(game.rating, this.rating) == 0 && this.ratingCount == game.ratingCount && this.hypes == game.hypes && this.follows == game.follows && Double.compare(game.ratingTotal, this.ratingTotal) == 0 && this.ratingTotalCount == game.ratingTotalCount && this.createdAt == game.createdAt && this.updatedAt == game.updatedAt && Objects.equals(this.name, game.name) && Objects.equals(this.collection, game.collection) && Objects.equals(this.cover, game.cover) && Objects.equals(this.storyline, game.storyline) && Objects.equals(this.externalGames, game.externalGames) && Objects.equals(this.firstReleaseDate, game.firstReleaseDate) && Objects.equals(this.gameModes, game.gameModes) && Objects.equals(this.keywords, game.keywords) && Objects.equals(this.platforms, game.platforms) && Objects.equals(this.releaseDates, game.releaseDates) && Objects.equals(this.gamesSimilar, game.gamesSimilar) && Objects.equals(this.slug, game.slug) && Objects.equals(this.summary, game.summary) && Objects.equals(this.tags, game.tags) && Objects.equals(this.themes, game.themes) && Objects.equals(this.url, game.url) && Objects.equals(this.videos, game.videos) && Objects.equals(this.websites, game.websites) && Objects.equals(this.ratingsAge, game.ratingsAge) && Objects.equals(this.screenshots, game.screenshots) && Objects.equals(this.modesMultiplayer, game.modesMultiplayer) && Objects.equals(this.companiesInvolved, game.companiesInvolved) && Objects.equals(this.genres, game.genres) && Objects.equals(this.gameEngines, game.gameEngines) && Objects.equals(this.franchises, game.franchises) && Objects.equals(this.artworks, game.artworks) && Objects.equals(this.bundles, game.bundles) && Objects.equals(this.franchise, game.franchise) && Objects.equals(this.timeToBeat, game.timeToBeat) && Objects.equals(this.expansions, game.expansions) && Objects.equals(this.expansionsStandalone, game.expansionsStandalone) && Objects.equals(this.dlcs, game.dlcs) && Objects.equals(this.perspectivesPlayer, game.perspectivesPlayer) && Objects.equals(this.parentVersion, game.parentVersion) && Objects.equals(this.titleVersion, game.titleVersion) && Objects.equals(this.checksum, game.checksum);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.category, this.status, this.name, this.collection, this.cover, this.storyline, this.externalGames, this.firstReleaseDate, this.gameModes, this.keywords, this.platforms, this.popularity, this.pulseCount, this.releaseDates, this.gamesSimilar, this.slug, this.summary, this.tags, this.themes, this.url, this.videos, this.websites, this.gameParent, this.ratingsAge, this.rating, this.ratingCount, this.screenshots, this.modesMultiplayer, this.companiesInvolved, this.genres, this.gameEngines, this.franchises, this.artworks, this.bundles, this.franchise, this.hypes, this.follows, this.timeToBeat, this.expansions, this.expansionsStandalone, this.dlcs, this.perspectivesPlayer, this.ratingTotal, this.ratingTotalCount, this.parentVersion, this.titleVersion, this.createdAt, this.updatedAt, this.checksum);
    }
}

