package de.blackrose01.model.pulse;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import de.blackrose01.model.game.Game;
import de.blackrose01.model.page.Page;

import java.io.Serializable;
import java.util.Objects;

/**
 * A news article source such as IGN.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class PulseSource implements Serializable {
    @JsonIgnore
    @JsonProperty(value = "id")
    private long id;
    @JsonIgnore
    @JsonProperty(value = "name")
    private String name;
    @JsonProperty(value = "page")
    private Object page;
    @JsonProperty(value = "game")
    private Object game;
    @JsonIgnore
    @JsonProperty(value = "checksum")
    private String checksum;

    public PulseSource() {
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public long getPage() {
        return Long.parseLong(String.valueOf(page));
    }

    @JsonIgnore
    public Page getPageObject() {
        return new ObjectMapper().convertValue(page, Page.class);
    }

    public void setPage(Object page) {
        this.page = page;
    }

    @JsonIgnore
    public long getGame() {
        return Long.parseLong(String.valueOf(game));
    }

    @JsonIgnore
    public Game getGameObject() {
        return new ObjectMapper().convertValue(game, Game.class);
    }

    public void setGame(Object game) {
        this.game = game;
    }

    public String getChecksum() {
        return checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    @Override
    public String toString() {
        return new Gson().toJson(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PulseSource that = (PulseSource) o;
        return id == that.id &&
                Objects.equals(name, that.name) &&
                Objects.equals(page, that.page) &&
                Objects.equals(game, that.game) &&
                Objects.equals(checksum, that.checksum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, page, game, checksum);
    }
}
