/*
 * Decompiled with CFR 0.152.
 */
package de.blackrose01;

import de.blackrose01.Postfixes;
import de.blackrose01.endpoint.Endpoint;
import de.blackrose01.endpoint.EndpointPrivate;
import de.blackrose01.endpoint.EndpointPublic;
import java.util.ArrayList;
import java.util.List;

public class Parameters {
    private List<String> filters = new ArrayList<String>();
    private String ids = "";
    private String fields = "fields *";
    private String order = "";
    private String offset = "";
    private String limit = "";
    private String search = "";
    private String exclude = "";

    public Parameters addId(long id) {
        this.ids = "id = (" + String.valueOf(id) + ")";
        return this;
    }

    public Parameters addId(long[] id) {
        CharSequence[] ids = new String[id.length];
        for (int i = 0; i < id.length; ++i) {
            ids[i] = String.valueOf(id[i]);
        }
        this.ids = "id = (" + String.join((CharSequence)",", ids) + ")";
        return this;
    }

    public Parameters addId(List<Long> id) {
        return this.addId((long[])long[].class.cast(id.toArray()));
    }

    public Parameters addFields(String fields) {
        this.fields = "fields " + fields.replace(" ", ",").toLowerCase();
        return this;
    }

    public Parameters addFields(String[] fields) {
        this.fields = "fields " + String.join((CharSequence)",", fields).toLowerCase();
        return this;
    }

    public Parameters addFields(List<String> fields) {
        return this.addFields(fields.toArray(new String[fields.size()]));
    }

    public Parameters addOffset(int offset) {
        this.offset = offset < 1 ? "" : (offset > 5000 ? "offset 5000" : "offset " + String.valueOf(offset));
        return this;
    }

    public Parameters addLimit(int limit) {
        this.limit = limit < 1 ? "" : (limit > 500 ? "limit 500" : "limit " + String.valueOf(limit));
        return this;
    }

    public Parameters addOrder(String field, boolean descending) {
        this.order = descending ? "sort " + field + " desc" : "sort " + field + " asc";
        return this;
    }

    public Parameters addSearch(Endpoint endpoint, String search) {
        if (endpoint == EndpointPublic.Character || endpoint == EndpointPublic.Collection || endpoint == EndpointPublic.Game || endpoint == EndpointPublic.Platform || endpoint == EndpointPrivate.People || endpoint == EndpointPublic.Theme) {
            this.search = "search \"" + search.replace(" ", "-").toLowerCase() + "\"";
        }
        return this;
    }

    public Parameters addExclude(String field) {
        this.exclude = "exclude " + field;
        return this;
    }

    public Parameters addFilter(String field, Postfixes comparator, Number n) {
        if (comparator.isRequireComparator() && comparator.isOnlyNumeric() || comparator.isRequireComparator() && comparator == Postfixes.Equal_Case_Sensitive) {
            this.filters.add(field + comparator.getPostfix() + String.valueOf(n));
        }
        return this;
    }

    public Parameters addFilter(String field, Postfixes comparator, String s) {
        if (!comparator.isOnlyNumeric() && s != null && comparator.isRequireComparator()) {
            this.filters.add(field + comparator.getPostfix() + s);
        }
        return this;
    }

    public Parameters addFilterNull(String field, Postfixes comparator) {
        if (comparator == Postfixes.Is_Null || comparator == Postfixes.Not_Null) {
            this.filters.add(field + comparator.getPostfix());
        }
        return this;
    }

    public Parameters addFilter(String[] values, Postfixes comparator) {
        if (!comparator.isRequireComparator() && comparator != Postfixes.Is_Null && comparator != Postfixes.Not_Null) {
            this.filters.add(comparator.getPostfix().replace("&LIST&", String.join((CharSequence)",", values)));
        }
        return this;
    }

    public Parameters addFilter(List<String> values, Postfixes comparator) {
        return this.addFilter(values.toArray(new String[values.size()]), comparator);
    }

    public Parameters resetFilterAll() {
        this.filters = new ArrayList<String>();
        this.ids = "";
        this.fields = "fields *";
        this.order = "";
        this.offset = "";
        this.limit = "";
        this.search = "";
        this.exclude = "";
        return this;
    }

    public Parameters resetFilterIds() {
        this.ids = "";
        return this;
    }

    public Parameters resetFilterFilters() {
        this.filters = new ArrayList<String>();
        return this;
    }

    public Parameters resetFilterFields() {
        this.fields = "fields *";
        return this;
    }

    public Parameters resetFilterOrder() {
        this.order = "";
        return this;
    }

    public Parameters resetFilterOffset() {
        this.offset = "";
        return this;
    }

    public Parameters resetFilterLimit() {
        this.limit = "";
        return this;
    }

    public Parameters resetFilterSearch() {
        this.search = "";
        return this;
    }

    public Parameters resetFilterExclude() {
        this.exclude = "";
        return this;
    }

    public String buildQuery() {
        String query = this.fields + ";";
        if (!this.ids.isEmpty()) {
            query = query + this.ids + ";";
        }
        if (!this.search.isEmpty()) {
            query = query + this.search + ";";
        }
        if (this.filters.size() > 0) {
            query = query + "where " + String.join((CharSequence)" & ", this.filters.toArray(new String[this.filters.size()])) + ";";
        }
        if (!this.order.isEmpty()) {
            query = query + this.order + ";";
        }
        if (!this.limit.isEmpty()) {
            query = query + this.limit + ";";
        }
        if (!this.offset.isEmpty() && !this.limit.isEmpty()) {
            query = query + this.offset + ";";
        }
        if (!this.exclude.isEmpty()) {
            query = query + this.exclude + ";";
        }
        return query;
    }
}

