/*
 * Decompiled with CFR 0.152.
 */
package de.blackrose01.model.achievement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import de.blackrose01.model.achievement.AchievementIcon;
import de.blackrose01.model.game.Game;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Achievement
implements Serializable {
    @JsonIgnore
    @JsonProperty(value="id")
    private long id;
    @JsonIgnore
    @JsonProperty(value="category")
    private int category;
    @JsonIgnore
    @JsonProperty(value="language")
    private int language;
    @JsonIgnore
    @JsonProperty(value="rank")
    private int rank;
    @JsonIgnore
    @JsonProperty(value="description")
    private String description;
    @JsonIgnore
    @JsonProperty(value="external_id")
    private String idExternal;
    @JsonProperty(value="game")
    private Object game;
    @JsonIgnore
    @JsonProperty(value="name")
    private String name;
    @JsonIgnore
    @JsonProperty(value="slug")
    private String slug;
    @JsonProperty(value="achievement_icon")
    private Object iconAchievement;
    @JsonProperty(value="locked_achievement_icon")
    private Object iconAchievementLocked;
    @JsonIgnore
    @JsonProperty(value="owners_percentage")
    private double percentageOwners;
    @JsonIgnore
    @JsonProperty(value="tags")
    private List<Long> tags;
    @JsonIgnore
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonIgnore
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonIgnore
    @JsonProperty(value="checksum")
    private String checksum;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public int getLanguage() {
        return this.language;
    }

    public void setLanguage(int language) {
        this.language = language;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIdExternal() {
        return this.idExternal;
    }

    public void setIdExternal(String idExternal) {
        this.idExternal = idExternal;
    }

    public long getGame() {
        return Long.parseLong(String.valueOf(this.game));
    }

    public Game getGameObject() {
        return (Game)new ObjectMapper().convertValue(this.game, Game.class);
    }

    public void setGame(Object game) {
        this.game = game;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    @JsonIgnore
    public long getIconAchievement() {
        return Long.parseLong(String.valueOf(this.iconAchievement));
    }

    @JsonIgnore
    public AchievementIcon getIconAchievementObject() {
        return (AchievementIcon)new ObjectMapper().convertValue(this.iconAchievement, AchievementIcon.class);
    }

    public void setIconAchievement(Object iconAchievement) {
        this.iconAchievement = iconAchievement;
    }

    @JsonIgnore
    public long getIconAchievementLocked() {
        return Long.parseLong(String.valueOf(this.iconAchievementLocked));
    }

    @JsonIgnore
    public AchievementIcon getIconAchievementLockedObject() {
        return (AchievementIcon)new ObjectMapper().convertValue(this.iconAchievementLocked, AchievementIcon.class);
    }

    public void setIconAchievementLocked(Object iconAchievementLocked) {
        this.iconAchievementLocked = iconAchievementLocked;
    }

    public double getPercentageOwners() {
        return this.percentageOwners;
    }

    public void setPercentageOwners(double percentageOwners) {
        this.percentageOwners = percentageOwners;
    }

    public List<Long> getTags() {
        return this.tags;
    }

    public void setTags(List<Long> tags) {
        this.tags = tags;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Achievement that = (Achievement)o;
        return this.id == that.id && this.category == that.category && this.language == that.language && this.rank == that.rank && Double.compare(that.percentageOwners, this.percentageOwners) == 0 && this.createdAt == that.createdAt && this.updatedAt == that.updatedAt && Objects.equals(this.description, that.description) && Objects.equals(this.idExternal, that.idExternal) && Objects.equals(this.game, that.game) && Objects.equals(this.name, that.name) && Objects.equals(this.slug, that.slug) && Objects.equals(this.iconAchievement, that.iconAchievement) && Objects.equals(this.iconAchievementLocked, that.iconAchievementLocked) && Objects.equals(this.tags, that.tags) && Objects.equals(this.checksum, that.checksum);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.category, this.language, this.rank, this.description, this.idExternal, this.game, this.name, this.slug, this.iconAchievement, this.iconAchievementLocked, this.percentageOwners, this.tags, this.createdAt, this.updatedAt, this.checksum);
    }
}

