/*
 * Decompiled with CFR 0.152.
 */
package de.blackrose01.model.platform;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import de.blackrose01.model.ProductFamily;
import de.blackrose01.model.platform.PlatformLogo;
import de.blackrose01.model.platform.PlatformVersion;
import de.blackrose01.model.platform.PlatformWebsite;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Platform
implements Serializable {
    @JsonIgnore
    @JsonProperty(value="id")
    private long id;
    @JsonIgnore
    @JsonProperty(value="abbreviation")
    private String abbreviation;
    @JsonIgnore
    @JsonProperty(value="category")
    private int category;
    @JsonIgnore
    @JsonProperty(value="name")
    private String name;
    @JsonIgnore
    @JsonProperty(value="alternative_name")
    private String nameAlternative;
    @JsonIgnore
    @JsonProperty(value="slug")
    private String slug;
    @JsonProperty(value="platform_logo")
    private Object platformLogo;
    @JsonProperty(value="versions")
    private List<Object> versions;
    @JsonProperty(value="websites")
    private List<Object> websites;
    @JsonProperty(value="product_family")
    private Object productFamily;
    @JsonIgnore
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonIgnore
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonIgnore
    @JsonProperty(value="checksum")
    private String checksum;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameAlternative() {
        return this.nameAlternative;
    }

    public void setNameAlternative(String nameAlternative) {
        this.nameAlternative = nameAlternative;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    @JsonIgnore
    public long getPlatformLogo() {
        return Long.parseLong(String.valueOf(this.platformLogo));
    }

    @JsonIgnore
    public PlatformLogo getPlatformLogoObject() {
        return (PlatformLogo)new ObjectMapper().convertValue(this.platformLogo, PlatformLogo.class);
    }

    public void setPlatformLogo(Object platformLogo) {
        this.platformLogo = platformLogo;
    }

    @JsonIgnore
    public List<Long> getVersions() {
        return (List)new ObjectMapper().convertValue(this.versions, (TypeReference)new TypeReference<List<Long>>(){});
    }

    @JsonIgnore
    public List<PlatformVersion> getVersionsObject() {
        return (List)new ObjectMapper().convertValue(this.versions, (TypeReference)new TypeReference<List<PlatformVersion>>(){});
    }

    public void setVersions(List<Object> versions) {
        this.versions = versions;
    }

    @JsonIgnore
    public List<Long> getWebsites() {
        return (List)new ObjectMapper().convertValue(this.websites, (TypeReference)new TypeReference<List<Long>>(){});
    }

    @JsonIgnore
    public List<PlatformWebsite> getWebsitesObject() {
        return (List)new ObjectMapper().convertValue(this.websites, (TypeReference)new TypeReference<List<PlatformWebsite>>(){});
    }

    public void setWebsites(List<Object> websites) {
        this.websites = websites;
    }

    @JsonIgnore
    public long getProductFamily() {
        return Long.parseLong(String.valueOf(this.productFamily));
    }

    @JsonIgnore
    public ProductFamily getProductFamilyObject() {
        return (ProductFamily)new ObjectMapper().convertValue(this.productFamily, ProductFamily.class);
    }

    public void setProductFamily(Object productFamily) {
        this.productFamily = productFamily;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Platform platform = (Platform)o;
        return this.id == platform.id && this.category == platform.category && this.createdAt == platform.createdAt && this.updatedAt == platform.updatedAt && Objects.equals(this.abbreviation, platform.abbreviation) && Objects.equals(this.name, platform.name) && Objects.equals(this.nameAlternative, platform.nameAlternative) && Objects.equals(this.slug, platform.slug) && Objects.equals(this.platformLogo, platform.platformLogo) && Objects.equals(this.versions, platform.versions) && Objects.equals(this.websites, platform.websites) && Objects.equals(this.productFamily, platform.productFamily) && Objects.equals(this.checksum, platform.checksum);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.abbreviation, this.category, this.name, this.nameAlternative, this.slug, this.platformLogo, this.versions, this.websites, this.productFamily, this.createdAt, this.updatedAt, this.checksum);
    }
}

