/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.spm.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ItemSet
implements Serializable {
    private static final long serialVersionUID = -1886446463506678412L;
    private List<String> items = new ArrayList<String>();
    private int parentSupport;
    private int support;

    public ItemSet(int count) {
        this.support = count;
    }

    public ItemSet() {
    }

    public List<String> getItems() {
        return this.items;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public int getSupport() {
        return this.support;
    }

    public void setSupport(int support) {
        this.support = support;
    }

    public String toString() {
        return "{" + this.items.stream().collect(Collectors.joining(", ")) + "} (support: " + this.getSupport() + ")";
    }

    public int countItems() {
        return this.items.size();
    }

    public String getItemAt(int k) {
        return this.items.get(k);
    }

    public boolean containsItem(String item) {
        return this.items.contains(item);
    }

    public void copy(ItemSet rhs) {
        this.items.clear();
        for (int i = 0; i < rhs.items.size(); ++i) {
            this.items.add(rhs.items.get(i));
        }
        this.support = rhs.support;
        this.parentSupport = rhs.parentSupport;
    }

    public ItemSet makeCopy() {
        ItemSet clone = new ItemSet();
        clone.copy(this);
        return clone;
    }

    public int getParentSupport() {
        return this.parentSupport;
    }

    public void setParentSupport(int parentSupport) {
        this.parentSupport = parentSupport;
    }

    public String lastItem() {
        return this.items.get(this.items.size() - 1);
    }

    public void incSupport() {
        ++this.support;
    }

    public void addAll(List<String> items) {
        this.items.addAll(items);
    }

    public int hashCode() {
        int hash = 3001;
        for (int i = 0; i < this.countItems(); ++i) {
            hash = hash * 31 + this.items.get(i).hashCode();
        }
        hash = hash * 31 + this.support;
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemSet)) {
            return false;
        }
        ItemSet rhs = (ItemSet)obj;
        if (this.countItems() != rhs.countItems()) {
            return false;
        }
        for (int i = 0; i < this.countItems(); ++i) {
            if (this.items.get(i).equals(rhs.items.get(i))) continue;
            return false;
        }
        return true;
    }

    public void addItem(String item) {
        this.items.add(item);
    }

    public void prependItem(String item) {
        List<String> temp = this.items;
        this.items = new ArrayList<String>();
        this.items.add(item);
        this.items.addAll(temp);
    }

    public String dropFirstItem() {
        return this.items.remove(0);
    }

    public String dropLastItem() {
        return this.items.remove(this.items.size() - 1);
    }

    public boolean isSubsetOf(ItemSet rhs) {
        for (String item : this.items) {
            if (rhs.containsItem(item)) continue;
            return false;
        }
        return true;
    }

    public String firstItem() {
        return this.items.get(0);
    }
}

