/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.spm.data;

import com.github.chen0040.spm.data.ItemSet;

public class ItemSetWithTimeId
extends ItemSet {
    private long time;
    private long timeId = -1L;

    public ItemSetWithTimeId(String[] items) {
        for (String item : items) {
            this.addItem(item);
        }
    }

    public ItemSetWithTimeId() {
    }

    public long getTimeId() {
        return this.timeId;
    }

    public void setTimeId(long timeId) {
        this.timeId = timeId;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
        if (this.timeId == -1L) {
            this.timeId = time;
        }
    }

    public boolean isBefore(ItemSetWithTimeId rhs) {
        return this.getTime() < rhs.getTime();
    }

    @Override
    public ItemSet makeCopy() {
        ItemSetWithTimeId clone = new ItemSetWithTimeId();
        clone.copy(this);
        return clone;
    }

    @Override
    public void copy(ItemSet obj) {
        super.copy(obj);
        if (obj instanceof ItemSetWithTimeId) {
            ItemSetWithTimeId rhs = (ItemSetWithTimeId)obj;
            this.timeId = rhs.timeId;
            this.time = rhs.time;
        }
    }

    public long timeElapsed(ItemSetWithTimeId earlierItemSet) {
        return this.getTime() - earlierItemSet.getTime();
    }

    @Override
    public boolean equals(Object rhs) {
        if (rhs instanceof ItemSet) {
            return super.equals(rhs);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

