/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.spm.data;

import com.github.chen0040.spm.data.ItemSetWithTimeId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sequence {
    private static final Logger logger = LoggerFactory.getLogger(Sequence.class);
    private List<ItemSetWithTimeId> elements = new ArrayList<ItemSetWithTimeId>();
    private int support;

    public static Sequence make(String ... args) {
        ArrayList<String> texts = new ArrayList<String>();
        for (String items : args) {
            texts.add(items);
        }
        List itemSets = texts.stream().map(text -> new ItemSetWithTimeId(text.split(","))).collect(Collectors.toList());
        Sequence sequence = new Sequence();
        for (ItemSetWithTimeId element : itemSets) {
            sequence.addElement(element);
        }
        return sequence;
    }

    public List<ItemSetWithTimeId> getElements() {
        return this.elements;
    }

    public boolean containsItem(String item) {
        for (ItemSetWithTimeId t : this.elements) {
            if (!t.containsItem(item)) continue;
            return true;
        }
        return false;
    }

    public void addElement(ItemSetWithTimeId itemSet) {
        this.elements.add(itemSet);
    }

    public Sequence dropFirstItem() {
        Sequence clone = this.makeCopy();
        clone.getElements().get(0).dropFirstItem();
        if (clone.firstElement().countItems() == 0) {
            clone.getElements().remove(0);
        }
        return clone;
    }

    private ItemSetWithTimeId firstElement() {
        return this.elements.get(0);
    }

    public Sequence makeCopy() {
        Sequence clone = new Sequence();
        clone.copy(this);
        return clone;
    }

    public void copy(Sequence rhs) {
        this.elements.clear();
        for (int i = 0; i < rhs.elements.size(); ++i) {
            ItemSetWithTimeId itemSet = rhs.elements.get(i);
            this.elements.add((ItemSetWithTimeId)itemSet.makeCopy());
        }
    }

    public Sequence dropLastItem() {
        Sequence clone = this.makeCopy();
        clone.lastElement().dropLastItem();
        if (clone.lastElement().countItems() == 0) {
            clone.getElements().remove(clone.countElements() - 1);
        }
        return clone;
    }

    public int hashCode() {
        int hash = 3001;
        for (int i = 0; i < this.elements.size(); ++i) {
            hash = hash * 31 + this.elements.get(i).hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sequence)) {
            return false;
        }
        Sequence rhs = (Sequence)obj;
        if (this.elements.size() != rhs.elements.size()) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.elements.get(i).equals(rhs.elements.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isLastItemSeparateElement() {
        return this.lastElement().countItems() == 1;
    }

    public boolean isFirstItemSeparateElement() {
        return this.firstElement().countItems() == 0;
    }

    public ItemSetWithTimeId lastElement() {
        return this.elements.get(this.elements.size() - 1);
    }

    public Sequence append(String item, boolean itemAsSeparateElement) {
        Sequence clone = this.makeCopy();
        if (itemAsSeparateElement) {
            ItemSetWithTimeId element = new ItemSetWithTimeId();
            element.addItem(item);
            clone.addElement(element);
        } else {
            ItemSetWithTimeId element = clone.lastElement();
            if (!element.containsItem(item)) {
                element.addItem(item);
            }
        }
        return clone;
    }

    public String lastItem() {
        return this.lastElement().lastItem();
    }

    public String firstItem() {
        return this.firstElement().firstItem();
    }

    public int countElements() {
        return this.elements.size();
    }

    public boolean contains(Sequence candidate, long maxTimeWindow) {
        int offset = 0;
        int prevOffset = -1;
        boolean contained = true;
        int candidateOffset = 0;
        while (candidateOffset < candidate.countElements()) {
            boolean maxTimeWindowExceeded = false;
            while (offset < this.countElements() && !candidate.elementAt(candidateOffset).isSubsetOf(this.elementAt(offset))) {
                if (++offset >= this.countElements() || prevOffset == -1 || maxTimeWindow <= 0L || this.elementAt(offset).timeElapsed(this.elementAt(prevOffset)) <= maxTimeWindow) continue;
                maxTimeWindowExceeded = true;
                break;
            }
            if (maxTimeWindowExceeded) {
                if (prevOffset != -1) {
                    --candidateOffset;
                    offset = prevOffset + 1;
                    continue;
                }
                contained = false;
                break;
            }
            if (offset == this.countElements()) {
                contained = false;
                break;
            }
            prevOffset = offset++;
            ++candidateOffset;
        }
        if (candidateOffset != candidate.countElements()) {
            contained = false;
        }
        return contained;
    }

    public ItemSetWithTimeId elementAt(int i) {
        return this.elements.get(i);
    }

    public boolean containsOnlyOneItem() {
        if (this.elements.size() == 1) {
            return this.elements.get(0).countItems() == 1;
        }
        return false;
    }

    public String toString() {
        return "<(" + this.elements.stream().map(element -> element.getItems().stream().collect(Collectors.joining(", "))).collect(Collectors.joining("), (")) + ")> [support: " + this.support + "]";
    }

    public void setSupport(int support) {
        this.support = support;
    }

    public int getSupport() {
        return this.support;
    }

    public int countItems() {
        return this.elements.stream().map(element -> element.countItems()).reduce((a, b) -> a + b).get();
    }

    public Sequence prepend(String item, boolean itemAsSeparateElement) {
        Sequence clone = this.makeCopy();
        if (itemAsSeparateElement) {
            ItemSetWithTimeId element = new ItemSetWithTimeId();
            element.prependItem(item);
            clone.prependElement(element);
        } else {
            ItemSetWithTimeId element = clone.firstElement();
            if (!element.containsItem(item)) {
                element.prependItem(item);
            }
        }
        return clone;
    }

    private void prependElement(ItemSetWithTimeId element) {
        List<ItemSetWithTimeId> temp = this.elements;
        this.elements = new ArrayList<ItemSetWithTimeId>();
        this.elements.add(element);
        this.elements.addAll(temp);
    }
}

