/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.HttpServerExchange;
import httpserver.error.InvalidInput;
import java.io.IOException;
import java.util.List;

public interface SessionStore<T> {
    default public String getSessionCookieName() {
        return "session";
    }

    default public String getSessionCookieConfiguration() {
        return "; Path=/; Secure; HttpOnly; SameSite=strict";
    }

    public void setSession(HttpServerExchange var1, T var2) throws IOException;

    public boolean existsSession(HttpServerExchange var1) throws IOException, InvalidInput;

    public T getSession(HttpServerExchange var1) throws IOException, InvalidInput;

    public T getSession(HttpServerExchange var1, T var2) throws IOException, InvalidInput;

    public void deleteSession(HttpServerExchange var1) throws IOException;

    public static String getValueForCookie(HttpServerExchange exchange, String cookieName) {
        List<String> headers = exchange.getRequestHeaders("Cookie");
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        String cookiePrefix = cookieName + "=";
        for (String header : headers) {
            for (String cookie : header.split(";")) {
                if (!cookie.trim().startsWith(cookiePrefix)) continue;
                return cookie.substring(cookie.indexOf(61) + 1).trim();
            }
        }
        return null;
    }
}

