/*
 * Decompiled with CFR 0.152.
 */
package httpserver.net;

import httpserver.net.ConnectionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.Executor;

public final class Connection {
    private boolean running = true;

    public Connection(Executor executor, Socket socket, ConnectionHandler handler) throws IOException {
        OutputStream out = socket.getOutputStream();
        InputStream in = socket.getInputStream();
        executor.execute(() -> {
            try (OutputStream outputStream = out;
                 InputStream inputStream = in;
                 Socket socket2 = socket;){
                while (this.running) {
                    handler.handleInput(in, out);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public boolean isAlive() {
        return this.running;
    }

    public void stop() {
        this.running = false;
    }
}

