/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.ContentType;
import httpserver.core.HttpServerExchange;
import httpserver.error.InvalidInput;
import httpserver.util.Functions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class ResponseBuilder {
    private final Function<Object, String> toJson;
    private final HttpServerExchange exchange;
    private final Map<String, String> headers = new HashMap<String, String>();
    private int status = 500;

    public static ResponseBuilder respond(HttpServerExchange httpServerExchange) throws InvalidInput {
        return new ResponseBuilder(httpServerExchange);
    }

    public static ResponseBuilder respond(HttpServerExchange httpServerExchange, Function<Object, String> function) throws InvalidInput {
        return new ResponseBuilder(httpServerExchange, function);
    }

    private ResponseBuilder(HttpServerExchange httpServerExchange) throws InvalidInput {
        this(httpServerExchange, null);
    }

    private ResponseBuilder(HttpServerExchange httpServerExchange, Function<Object, String> function) throws InvalidInput {
        this.exchange = Functions.requireNotNull(httpServerExchange, "HttpServerExchange must not be null");
        this.toJson = function;
    }

    public ResponseBuilder status(int n) throws InvalidInput {
        this.status = Functions.requireTrue(n >= 100 && n < 999, n, "Status must be a valid HTTP status code");
        return this;
    }

    public ResponseBuilder header(String string, String string2) {
        this.headers.put(string, string2);
        return this;
    }

    public ResponseBuilder header(String string, int n) {
        this.headers.put(string, Integer.toString(n));
        return this;
    }

    public ResponseBuilder header(String string, long l) {
        this.headers.put(string, Long.toString(l));
        return this;
    }

    public ResponseBuilder contentType(String string) {
        this.headers.put("Content-Type", string);
        return this;
    }

    public ResponseBuilder contentType(ContentType contentType) {
        this.headers.put("Content-Type", contentType.toString());
        return this;
    }

    public ResponseBuilder redirect(String string) {
        this.status = 302;
        this.headers.put("Location", string);
        return this;
    }

    private void preSend() {
        this.exchange.setStatusCode(this.status);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            this.exchange.setResponseHeader(entry.getKey(), entry.getValue());
        }
    }

    public void send(String string) {
        this.preSend();
        this.exchange.send(string, StandardCharsets.UTF_8);
    }

    public void send(byte[] byArray) {
        this.preSend();
        this.exchange.send(byArray);
    }

    public void send(InputStream inputStream) throws IOException {
        this.preSend();
        this.exchange.send(inputStream.readAllBytes());
    }

    public void send(Object object) {
        if (this.toJson == null) {
            throw new IllegalStateException("Missing serializer");
        }
        this.preSend();
        this.exchange.send(this.toJson.apply(object), StandardCharsets.UTF_8);
    }

    public void send() {
        this.preSend();
    }
}

