/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import java.util.Map;

public interface ContentType {
    public static final ContentType text_plain = ContentType.newContentType("text/plain; charset=UTF-8");
    public static final ContentType text_html = ContentType.newContentType("text/html; charset=UTF-8");
    public static final ContentType application_json = ContentType.newContentType("application/json");
    public static final ContentType application_pdf = ContentType.newContentType("application/pdf");
    public static final Map<String, String> CONTENT_TYPE_MAP = Map.ofEntries(Map.entry(".ico", "image/x-icon"), Map.entry(".gif", "image/gif"), Map.entry(".jpg", "image/jpeg"), Map.entry(".jpeg", "image/jpeg"), Map.entry(".png", "image/png"), Map.entry(".svg", "image/svg+xml"), Map.entry(".htm", "text/html"), Map.entry(".html", "text/html"), Map.entry(".json", "application/json"), Map.entry(".pdf", "application/pdf"));

    public static ContentType newContentType(final String string) {
        return new ContentType(){

            public String toString() {
                return string;
            }
        };
    }

    public static String toContentType(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "application/octet-stream";
        }
        String string2 = string.substring(n);
        return CONTENT_TYPE_MAP.getOrDefault(string2, "application/octet-stream");
    }
}

