/*
 * Decompiled with CFR 0.152.
 */
package httpserver.handlers;

import httpserver.core.HttpServerExchange;
import httpserver.handlers.SessionHttpHandler;
import java.util.HashMap;
import java.util.Map;

public class SessionMethodPathRouting<T>
implements SessionHttpHandler<T> {
    private final Map<String, Map<String, SessionHttpHandler>> routes = new HashMap<String, Map<String, SessionHttpHandler>>();
    private SessionHttpHandler fallback = (object, httpServerExchange) -> httpServerExchange.setStatusCode(404);

    public static SessionMethodPathRouting sessionRouting() {
        return new SessionMethodPathRouting();
    }

    public SessionMethodPathRouting fallback(SessionHttpHandler sessionHttpHandler) {
        this.fallback = sessionHttpHandler;
        return this;
    }

    public SessionMethodPathRouting head(String string2, SessionHttpHandler sessionHttpHandler) {
        this.routes.computeIfAbsent("HEAD", string -> new HashMap()).put(string2, sessionHttpHandler);
        return this;
    }

    public SessionMethodPathRouting get(String string2, SessionHttpHandler sessionHttpHandler) {
        this.routes.computeIfAbsent("GET", string -> new HashMap()).put(string2, sessionHttpHandler);
        return this;
    }

    public SessionMethodPathRouting put(String string2, SessionHttpHandler sessionHttpHandler) {
        this.routes.computeIfAbsent("PUT", string -> new HashMap()).put(string2, sessionHttpHandler);
        return this;
    }

    public SessionMethodPathRouting post(String string2, SessionHttpHandler sessionHttpHandler) {
        this.routes.computeIfAbsent("POST", string -> new HashMap()).put(string2, sessionHttpHandler);
        return this;
    }

    public SessionMethodPathRouting patch(String string2, SessionHttpHandler sessionHttpHandler) {
        this.routes.computeIfAbsent("PATCH", string -> new HashMap()).put(string2, sessionHttpHandler);
        return this;
    }

    public SessionMethodPathRouting delete(String string2, SessionHttpHandler sessionHttpHandler) {
        this.routes.computeIfAbsent("DELETE", string -> new HashMap()).put(string2, sessionHttpHandler);
        return this;
    }

    @Override
    public void handleRequest(T t, HttpServerExchange httpServerExchange) throws Exception {
        Map<String, SessionHttpHandler> map = this.routes.get(httpServerExchange.getRequestMethod());
        SessionHttpHandler sessionHttpHandler = map == null ? this.fallback : map.getOrDefault(httpServerExchange.getRequestPath(), this.fallback);
        sessionHttpHandler.handleRequest(t, httpServerExchange);
    }
}

