/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.functions;

import com.trigersoft.jaque.expression.BinaryExpression;
import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionType;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.InvocationExpression;
import com.trigersoft.jaque.expression.LambdaExpression;
import com.trigersoft.jaque.expression.MemberExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.UnaryExpression;
import java.util.ArrayList;
import java.util.List;

public class SqlConverter
implements ExpressionVisitor<StringBuilder> {
    private StringBuilder sb = new StringBuilder();
    private Expression body;
    private List<ConstantExpression> parameters = new ArrayList<ConstantExpression>();

    private static String toSqlOp(int expressionType) {
        switch (expressionType) {
            case 10: {
                return "=";
            }
            case 2: {
                return "AND";
            }
            case 30: {
                return "OR";
            }
            case 8: {
                return "";
            }
        }
        return ExpressionType.toString(expressionType);
    }

    @Override
    public StringBuilder visit(BinaryExpression e) {
        boolean quote;
        boolean bl = quote = e != this.body && e.getExpressionType() == 30;
        if (quote) {
            this.sb.append('(');
        }
        e.getFirst().accept(this);
        this.sb.append(' ').append(SqlConverter.toSqlOp(e.getExpressionType())).append(' ');
        e.getSecond().accept(this);
        if (quote) {
            this.sb.append(')');
        }
        return this.sb;
    }

    @Override
    public StringBuilder visit(ConstantExpression e) {
        if (e.getValue() instanceof String) {
            return this.sb.append("'").append(e.getValue().toString()).append("'");
        }
        return this.sb.append(e.getValue().toString());
    }

    @Override
    public StringBuilder visit(InvocationExpression e) {
        e.getArguments().stream().filter(x -> x instanceof ConstantExpression).forEach(x -> this.parameters.add((ConstantExpression)x));
        return e.getTarget().accept(this);
    }

    @Override
    public StringBuilder visit(LambdaExpression<?> e) {
        this.body = e.getBody();
        return this.body.accept(this);
    }

    @Override
    public StringBuilder visit(MemberExpression e) {
        Object name = e.getMember().getName();
        name = ((String)name).replaceAll("^(get)", "");
        name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
        return this.sb.append((String)name);
    }

    @Override
    public StringBuilder visit(ParameterExpression e) {
        this.parameters.get(e.getIndex()).accept(this);
        return this.sb;
    }

    @Override
    public StringBuilder visit(UnaryExpression e) {
        this.sb.append(SqlConverter.toSqlOp(e.getExpressionType()));
        return e.getFirst().accept(this);
    }
}

