/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.pagination;

import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.modules.CachingModule;
import com.github.collinalpert.java2db.modules.LazyModule;
import com.github.collinalpert.java2db.pagination.PaginationResult;
import com.github.collinalpert.java2db.queries.Query;
import java.time.Duration;
import java.util.List;
import java.util.stream.Stream;

public class CacheablePaginationResult<T extends BaseEntity>
extends PaginationResult<T> {
    private final Duration cacheExpiration;
    private final LazyModule<CachingModule<List<T>>> listCache;
    private final LazyModule<CachingModule<Stream<T>>> streamCache;
    private final LazyModule<CachingModule<T[]>> arrayCache;

    public CacheablePaginationResult(List<Query<T>> queries, Duration cacheExpiration) {
        super(queries);
        this.cacheExpiration = cacheExpiration;
        this.listCache = new LazyModule<CachingModule>(CachingModule::new);
        this.streamCache = new LazyModule<CachingModule>(CachingModule::new);
        this.arrayCache = new LazyModule<CachingModule>(CachingModule::new);
    }

    @Override
    public List<T> getPage(int number) {
        return this.listCache.getValue().getOrAdd(Integer.toString(number), () -> super.getPage(number), this.cacheExpiration);
    }

    @Override
    public Stream<T> getPageAsStream(int number) {
        return this.streamCache.getValue().getOrAdd(Integer.toString(number), () -> super.getPageAsStream(number), this.cacheExpiration);
    }

    @Override
    public T[] getPageAsArray(int number) {
        return this.arrayCache.getValue().getOrAdd(Integer.toString(number), () -> super.getPageAsArray(number), this.cacheExpiration);
    }

    public void invalidateCaches() {
        this.invalidateCache(null);
    }

    public void invalidateCache(String name) {
        this.listCache.getValue().invalidate(name);
        this.streamCache.getValue().invalidate(name);
    }
}

