/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionClassVisitor;
import com.trigersoft.jaque.expression.InvocableExpression;
import com.trigersoft.jaque.expression.InvocationExpression;
import com.trigersoft.jaque.expression.LambdaExpression;
import com.trigersoft.jaque.expression.MemberExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.SerializedLambda;
import com.trigersoft.jaque.expression.SimpleExpressionVisitor;
import com.trigersoft.jaque.expression.TypeConverter;
import com.trigersoft.jaque.expression.UnaryExpression;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;

class ExpressionClassCracker {
    private static final String DUMP_FOLDER_SYSTEM_PROPERTY = "jdk.internal.lambda.dumpProxyClasses";
    private static final URLClassLoader lambdaClassLoader;
    private static final String lambdaClassLoaderCreationError;
    private static ExpressionClassCracker instance;

    public static ExpressionClassCracker get() {
        return instance;
    }

    private ExpressionClassCracker() {
    }

    LambdaExpression<?> lambda(Object lambda) {
        Class<?> lambdaClass = lambda.getClass();
        if (!lambdaClass.isSynthetic()) {
            throw new IllegalArgumentException("The requested object is not a Java lambda");
        }
        if (lambda instanceof Serializable) {
            SerializedLambda extracted = SerializedLambda.extractLambda((Serializable)lambda);
            ClassLoader lambdaClassLoader = lambdaClass.getClassLoader();
            return this.lambda(extracted, lambdaClassLoader);
        }
        return this.lambdaFromFileSystem(lambda, null);
    }

    LambdaExpression<?> lambdaFromFileSystem(Object lambda, Method lambdaMethod) {
        ExpressionClassVisitor lambdaVisitor = this.parseFromFileSystem(lambda, lambdaMethod);
        return this.createLambda(lambdaVisitor);
    }

    LambdaExpression<?> lambdaFromClassLoader(ClassLoader classLoader, String className, Supplier<ConstantExpression> instance, String method, String methodDescriptor) {
        ExpressionClassVisitor lambdaVisitor = this.parseClass(classLoader, className, instance, method, methodDescriptor);
        return this.createLambda(lambdaVisitor);
    }

    private LambdaExpression<?> createLambda(ExpressionClassVisitor lambdaVisitor) {
        List<ParameterExpression> lambdaParams;
        Class<?> lambdaType;
        Expression lambdaExpression;
        block5: {
            InvocationExpression invocation;
            InvocableExpression target;
            lambdaExpression = lambdaVisitor.getResult();
            lambdaType = lambdaVisitor.getType();
            lambdaParams = Arrays.asList(lambdaVisitor.getParams());
            Expression stripped = this.stripConvertExpressions(lambdaExpression);
            if (stripped instanceof InvocationExpression && (target = (invocation = (InvocationExpression)stripped).getTarget()) instanceof LambdaExpression && lambdaType.isAssignableFrom(target.getResultType())) {
                List<ParameterExpression> params = lambdaParams;
                List<Expression> args = invocation.getArguments();
                int psize = params.size();
                if (psize == args.size()) {
                    for (int i = 0; i < psize; ++i) {
                        Expression arg = args.get(i);
                        if (arg instanceof ParameterExpression) {
                            ParameterExpression parg = (ParameterExpression)arg;
                            ParameterExpression param = params.get(i);
                            if (parg.getIndex() == param.getIndex() && param.getResultType().isAssignableFrom(parg.getResultType())) {
                                continue;
                            }
                        }
                        break block5;
                    }
                    return (LambdaExpression)target;
                }
            }
        }
        Expression actualExpression = TypeConverter.convert(lambdaExpression, lambdaType);
        return Expression.lambda(lambdaType, actualExpression, lambdaParams);
    }

    LambdaExpression<?> lambda(SerializedLambda extracted, ClassLoader lambdaClassLoader) {
        int boundArgs;
        int i;
        boolean hasCapturedArgs = extracted.capturedArgs != null && extracted.capturedArgs.length > 0;
        boolean[] hasThis = hasCapturedArgs ? new boolean[1] : null;
        ExpressionClassVisitor actualVisitor = this.parseClass(lambdaClassLoader, extracted.implClass, hasCapturedArgs ? () -> {
            hasThis[0] = true;
            Object instance = extracted.capturedArgs[0];
            return Expression.constant(instance);
        } : null, extracted.implMethodName, extracted.implMethodSignature);
        Expression reducedExpression = TypeConverter.convert(actualVisitor.getResult(), actualVisitor.getType());
        ParameterExpression[] params = actualVisitor.getParams();
        LambdaExpression extractedLambda = Expression.lambda(actualVisitor.getType(), reducedExpression, Collections.unmodifiableList(Arrays.asList(params)));
        if (!hasCapturedArgs) {
            return extractedLambda;
        }
        ArrayList<Expression> args = new ArrayList<Expression>(params.length);
        int capturedLength = extracted.capturedArgs.length;
        int n = i = hasThis != null && hasThis[0] ? 1 : 0;
        while (i < capturedLength) {
            LambdaExpression<?> arg = extracted.capturedArgs[i];
            if (arg instanceof SerializedLambda) {
                SerializedLambda argLambda = (SerializedLambda)((Object)arg);
                LambdaExpression<?> argExtractedLambda = this.lambda(argLambda, lambdaClassLoader);
                extractedLambda = (LambdaExpression)extractedLambda.accept(new ParameterReplacer(args.size(), null));
                arg = argExtractedLambda;
            }
            args.add(Expression.constant(arg));
            ++i;
        }
        ArrayList<ParameterExpression> finalParams = new ArrayList<ParameterExpression>(params.length - capturedLength);
        for (int y = boundArgs = args.size(); y < params.length; ++y) {
            ParameterExpression param = params[y];
            ParameterExpression arg = Expression.parameter(param.getResultType(), y - boundArgs);
            args.add(arg);
            finalParams.add(arg);
        }
        InvocationExpression newTarget = Expression.invoke(extractedLambda, args);
        return Expression.lambda(actualVisitor.getType(), newTarget, Collections.unmodifiableList(finalParams));
    }

    <T extends Expression> T parseSyntheticArguments(T expression, List<Expression> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            Object value;
            Expression e = arguments.get(i);
            if (e.getExpressionType() != 7 || (value = ((ConstantExpression)e).getValue()) == null || !value.getClass().isSynthetic()) continue;
            ParameterReplacer replacer = new ParameterReplacer(i, value);
            expression = expression.accept(replacer);
            if (replacer.getParsedLambda() == null) continue;
            arguments.set(i, Expression.constant(replacer.getParsedLambda()));
        }
        return (T)expression;
    }

    ExpressionClassVisitor parseFromFileSystem(Object lambda, Method lambdaMethod) {
        Class<?> lambdaClass;
        if (lambdaClassLoader == null) {
            throw new RuntimeException(lambdaClassLoaderCreationError);
        }
        if (lambdaMethod == null) {
            lambdaClass = lambda.getClass();
            lambdaMethod = this.findFunctionalMethod(lambdaClass);
        } else {
            lambdaClass = lambdaMethod.getDeclaringClass();
        }
        String lambdaClassName = this.lambdaClassName(lambdaClass);
        return this.parseClass(lambdaClassLoader, lambdaClassName, () -> Expression.constant(lambda), lambdaMethod);
    }

    private String lambdaClassName(Class<?> lambdaClass) {
        String lambdaClassName = lambdaClass.getName();
        int lastIndexOfSlash = lambdaClassName.lastIndexOf(47);
        String className = lastIndexOfSlash > 0 ? lambdaClassName.substring(0, lastIndexOfSlash) : lambdaClassName;
        return className;
    }

    private String classFilePath(String className) {
        return className.replace('.', '/') + ".class";
    }

    private Method findFunctionalMethod(Class<?> functionalClass) {
        for (Method m : functionalClass.getMethods()) {
            if (m.isDefault()) continue;
            return m;
        }
        throw new IllegalArgumentException("Not a lambda expression. No non-default method.");
    }

    private ExpressionClassVisitor parseClass(ClassLoader classLoader, String className, Supplier<ConstantExpression> instance, Method method) {
        return this.parseClass(classLoader, className, instance, method.getName(), Type.getMethodDescriptor(method));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExpressionClassVisitor parseClass(ClassLoader classLoader, String className, Supplier<ConstantExpression> instance, String method, String methodDescriptor) {
        String classFilePath = this.classFilePath(className);
        ExpressionClassVisitor visitor = new ExpressionClassVisitor(classLoader, instance, method, methodDescriptor);
        try (InputStream classStream = this.getResourceAsStream(classLoader, classFilePath);){
            ClassReader reader = new ClassReader(classStream);
            reader.accept(visitor, 6);
            ExpressionClassVisitor expressionClassVisitor = visitor;
            return expressionClassVisitor;
        }
        catch (IOException e) {
            throw new RuntimeException("error parsing class file " + classFilePath, e);
        }
    }

    private InputStream getResourceAsStream(ClassLoader classLoader, String path) throws FileNotFoundException {
        InputStream stream = classLoader.getResourceAsStream(path);
        if (stream == null) {
            throw new FileNotFoundException(path);
        }
        return stream;
    }

    private Expression stripConvertExpressions(Expression expression) {
        while (expression.getExpressionType() == 8) {
            expression = ((UnaryExpression)expression).getFirst();
        }
        return expression;
    }

    static {
        instance = new ExpressionClassCracker();
        String folderPath = System.getProperty(DUMP_FOLDER_SYSTEM_PROPERTY);
        if (folderPath == null) {
            lambdaClassLoaderCreationError = "Ensure that the 'jdk.internal.lambda.dumpProxyClasses' system property is properly set.";
            lambdaClassLoader = null;
        } else {
            File folder = new File(folderPath);
            if (!folder.isDirectory()) {
                lambdaClassLoaderCreationError = "Ensure that the 'jdk.internal.lambda.dumpProxyClasses' system property is properly set (" + folderPath + " does not exist).";
                lambdaClassLoader = null;
            } else {
                URL folderURL;
                try {
                    folderURL = folder.toURI().toURL();
                }
                catch (MalformedURLException mue) {
                    throw new RuntimeException(mue);
                }
                lambdaClassLoaderCreationError = null;
                lambdaClassLoader = new URLClassLoader(new URL[]{folderURL});
            }
        }
    }

    private static final class ParameterReplacer
    extends SimpleExpressionVisitor {
        private List<Integer> paramIndices;
        private final Object lambda;
        private LambdaExpression<?> parsedLambda;

        public ParameterReplacer(int paramIndex, Object lambda) {
            this.paramIndices = Arrays.asList(paramIndex);
            this.lambda = lambda;
        }

        public LambdaExpression<?> getParsedLambda() {
            return this.parsedLambda;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Expression visit(InvocationExpression e) {
            if (this.paramIndices.isEmpty()) {
                return e;
            }
            List<Integer> paramIndices = this.paramIndices;
            try {
                InvocableExpression target = e.getTarget();
                Expression expr = null;
                if (target instanceof MemberExpression) {
                    expr = target.accept(this);
                }
                List<Expression> args = this.visitArguments(e.getArguments());
                if (expr == null) {
                    expr = target.accept(this);
                }
                if (args != e.getArguments() || expr != e.getTarget()) {
                    InvocationExpression invocationExpression = Expression.invoke((InvocableExpression)expr, args);
                    return invocationExpression;
                }
                InvocationExpression invocationExpression = e;
                return invocationExpression;
            }
            finally {
                this.paramIndices = paramIndices;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<Expression> visitArguments(List<Expression> original) {
            try {
                List<Expression> list = super.visitArguments(original);
                return list;
            }
            finally {
                List<Integer> paramIndices = this.paramIndices;
                ArrayList<Integer> newParamIndices = new ArrayList<Integer>();
                for (int i = 0; i < original.size(); ++i) {
                    ParameterExpression p;
                    Expression e = original.get(i);
                    if (e.getExpressionType() != 33 || !paramIndices.contains((p = (ParameterExpression)e).getIndex())) continue;
                    newParamIndices.add(i);
                }
                this.paramIndices = newParamIndices;
            }
        }

        @Override
        public Expression visit(MemberExpression e) {
            int index;
            Expression instance = e.getInstance();
            if (instance.getExpressionType() == 33 && this.paramIndices.contains(index = ((ParameterExpression)instance).getIndex())) {
                if (this.lambda != null && this.parsedLambda == null) {
                    Method method = (Method)e.getMember();
                    try {
                        method = this.lambda.getClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new RuntimeException(nsme);
                    }
                    this.parsedLambda = ExpressionClassCracker.get().lambdaFromFileSystem(this.lambda, method);
                }
                return Expression.delegate(e.getResultType(), Expression.parameter(LambdaExpression.class, index), e.getParameters());
            }
            return super.visit(e);
        }
    }
}

