/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionClassCracker;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.Interpreter;
import com.trigersoft.jaque.expression.InvocableExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.SimpleExpressionVisitor;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;

public final class LambdaExpression<F>
extends InvocableExpression {
    private final Expression _body;
    private static final Map<Class<?>, WeakReference<LambdaExpression<?>>> _cache = Collections.synchronizedMap(new WeakHashMap());

    LambdaExpression(Class<?> resultType, Expression body, List<ParameterExpression> params) {
        super(16, resultType, params);
        if (body == null) {
            throw new NullPointerException("body");
        }
        this._body = body;
    }

    public Expression getBody() {
        return this._body;
    }

    public static <T> LambdaExpression<T> parse(T lambda) {
        LambdaExpression<?> lambdaE = ExpressionClassCracker.get().lambda(lambda);
        return lambdaE;
    }

    public Function<Object[], ?> compile() {
        Function f = (Function)this.accept(Interpreter.Instance);
        return f;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._body == null ? 0 : this._body.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LambdaExpression)) {
            return false;
        }
        LambdaExpression other = (LambdaExpression)obj;
        return !(this._body == null ? other._body != null : !this._body.equals(other._body));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        List<ParameterExpression> arguments = this.getParameters();
        if (arguments.size() > 0) {
            b.append('(');
            for (int i = 0; i < arguments.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                    b.append(' ');
                }
                ParameterExpression pe = arguments.get(i);
                b.append(pe.getResultType().getName());
                b.append(' ');
                b.append(pe.toString());
            }
            b.append(')');
        }
        b.append(" -> ");
        b.append(this.getBody().toString());
        b.append('}');
        return b.toString();
    }

    private static final class InstanceReplacer
    extends SimpleExpressionVisitor {
        private final Object _lambda;

        public InstanceReplacer(Object lambda) {
            this._lambda = lambda;
        }

        @Override
        public Expression visit(ConstantExpression e) {
            if (e.getResultType() == this._lambda.getClass()) {
                return Expression.constant(this._lambda);
            }
            return super.visit(e);
        }
    }
}

