/*
 * Decompiled with CFR 0.152.
 */
package com.github.crob1140.confluence;

import com.github.crob1140.confluence.auth.AuthMethod;
import com.github.crob1140.confluence.content.Content;
import com.github.crob1140.confluence.errors.ConfluenceRequestException;
import com.github.crob1140.confluence.errors.ErrorResponse;
import com.github.crob1140.confluence.requests.ConfluenceRequest;
import com.github.crob1140.confluence.requests.CreateContentRequest;
import com.github.crob1140.confluence.requests.GetContentRequest;
import com.github.crob1140.confluence.requests.GetContentResponse;
import com.github.crob1140.confluence.requests.UpdateContentRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ConfluenceClient {
    private AuthMethod authMethod;
    private WebTarget wikiTarget;

    public ConfluenceClient(WebTarget wikiTarget) {
        this.wikiTarget = wikiTarget;
    }

    public ConfluenceClient(WebTarget wikiTarget, AuthMethod authMethod) {
        this(wikiTarget);
        this.authMethod = authMethod;
    }

    public List<Content> getContent(GetContentRequest request) throws ConfluenceRequestException {
        return ((GetContentResponse)this.performRequest(request)).getResults();
    }

    public Content updateContent(UpdateContentRequest request) throws ConfluenceRequestException {
        return (Content)this.performRequest(request);
    }

    public Content createContent(CreateContentRequest request) throws ConfluenceRequestException {
        return (Content)this.performRequest(request);
    }

    Object performRequest(ConfluenceRequest request) throws ConfluenceRequestException {
        Response response;
        WebTarget endpointTarget = this.wikiTarget.path(request.getRelativePath());
        for (Map.Entry<String, String> queryParam : request.getQueryParams().entrySet()) {
            endpointTarget = endpointTarget.queryParam(queryParam.getKey(), new Object[]{queryParam.getValue()});
        }
        Invocation.Builder invocationBuilder = endpointTarget.request();
        Map<String, String> headers = this.getRequestHeaders(request);
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            invocationBuilder.header(headerEntry.getKey(), (Object)headerEntry.getValue());
        }
        String methodName = request.getMethod();
        if (request.getBodyEntity().isPresent()) {
            Object bodyEntity = request.getBodyEntity().get();
            response = invocationBuilder.method(methodName, Entity.json((Object)bodyEntity));
        } else {
            response = invocationBuilder.method(methodName);
        }
        int statusCode = response.getStatus();
        if (response.getStatus() >= 300) {
            String errorMsg;
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)response.getMediaType())) {
                ErrorResponse errResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                errorMsg = errResponse.getMessage();
            } else {
                errorMsg = response.getStatusInfo().getReasonPhrase();
            }
            throw new ConfluenceRequestException(statusCode, errorMsg);
        }
        return response.readEntity(request.getReturnType());
    }

    private Map<String, String> getRequestHeaders(ConfluenceRequest request) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", request.getContentType().toString());
        requestHeaders.put("Accept", request.getAcceptedResponseType().toString());
        if (this.authMethod != null) {
            requestHeaders.put("Authorization", this.authMethod.getAuthHeaderValue());
        }
        return requestHeaders;
    }
}

