/*
 * Decompiled with CFR 0.152.
 */
package com.github.crob1140.confluence.content;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.crob1140.confluence.content.ContentBody;
import com.github.crob1140.confluence.content.ContentStatus;
import com.github.crob1140.confluence.content.Metadata;
import com.github.crob1140.confluence.content.StandardContentType;
import com.github.crob1140.confluence.content.Version;
import com.github.crob1140.confluence.spaces.Space;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Content {
    @JsonProperty
    private String id;
    @JsonProperty
    private String type;
    @JsonProperty
    private ContentStatus status;
    @JsonProperty
    private String title;
    @JsonProperty
    private Space space;
    @JsonProperty
    private List<Content> ancestors;
    @JsonProperty
    private ContentBody body;
    @JsonProperty
    private Metadata metadata;
    @JsonProperty
    private Version version;

    private Content() {
    }

    private Content(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.status = builder.status;
        this.title = builder.title;
        this.space = builder.space;
        this.ancestors = builder.ancestors;
        this.body = builder.body;
        this.metadata = builder.metadata;
        this.version = builder.version;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public ContentStatus getStatus() {
        return this.status;
    }

    public String getTitle() {
        return this.title;
    }

    public Space getSpace() {
        return this.space;
    }

    public List<Content> getAncestors() {
        return this.ancestors;
    }

    public ContentBody getBody() {
        return this.body;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Version getVersion() {
        return this.version;
    }

    public static class Builder {
        private String id;
        private String type;
        private ContentStatus status;
        private String title;
        private Space space;
        private List<Content> ancestors;
        private ContentBody body;
        private Metadata metadata;
        private Version version;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setType(StandardContentType type) {
            this.type = type.getIdentifier();
            return this;
        }

        public Builder setStatus(ContentStatus status) {
            this.status = status;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setSpaceKey(String spaceKey) {
            this.space = new Space(spaceKey);
            return this;
        }

        public Builder setBody(ContentBody body) {
            this.body = body;
            return this;
        }

        public Builder setAncestors(List<Content> ancestors) {
            this.ancestors = ancestors;
            return this;
        }

        public Builder setMetadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setVersion(Version version) {
            this.version = version;
            return this;
        }

        public Content build() {
            return new Content(this);
        }
    }
}

