/*
 * Decompiled with CFR 0.152.
 */
package com.github.crob1140.confluence.content.expand;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExpandedBodyFormatProperties {
    private final Set<String> properties;

    private ExpandedBodyFormatProperties(Builder builder) {
        this.properties = Collections.unmodifiableSet(builder.properties);
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public static class Builder {
        private Set<String> properties = new HashSet<String>();

        public Builder addValue() {
            this.properties.add("value");
            return this;
        }

        public Builder addRepresentation() {
            this.properties.add("representation");
            return this;
        }

        public Builder addWebResource() {
            this.properties.add("webresource");
            return this;
        }

        public Builder addEmbeddedContent() {
            this.properties.add("embeddedContent");
            return this;
        }

        public Builder addMediaToken() {
            this.properties.add("mediaToken");
            return this;
        }

        public ExpandedBodyFormatProperties build() {
            return new ExpandedBodyFormatProperties(this);
        }
    }
}

