/*
 * Decompiled with CFR 0.152.
 */
package com.github.crob1140.confluence.content.expand;

import com.github.crob1140.confluence.content.ContentBodyType;
import com.github.crob1140.confluence.content.expand.ExpandedBodyFormatProperties;
import com.github.crob1140.confluence.content.expand.ExpandedChildTypeProperties;
import com.github.crob1140.confluence.content.expand.ExpandedChildrenProperties;
import com.github.crob1140.confluence.content.expand.ExpandedDescendantsProperties;
import com.github.crob1140.confluence.content.expand.ExpandedHistoryProperties;
import com.github.crob1140.confluence.content.expand.ExpandedMetadataProperties;
import com.github.crob1140.confluence.content.expand.ExpandedRestrictionProperties;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExpandedContentProperties {
    private final Set<String> properties;

    private ExpandedContentProperties(Builder builder) {
        this.properties = Collections.unmodifiableSet(builder.properties);
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public static class Builder {
        private Set<String> properties = new HashSet<String>();

        public Builder addChildTypes(ExpandedChildTypeProperties childTypes) {
            childTypes.getProperties().stream().map(property -> "childTypes." + property).forEach(property -> this.properties.add((String)property));
            return this;
        }

        public Builder addContainer() {
            this.properties.add("container");
            return this;
        }

        public Builder addMetadata(ExpandedMetadataProperties properties) {
            properties.getProperties().stream().map(property -> "metadata." + property).forEach(property -> this.properties.add((String)property));
            return this;
        }

        public Builder addOperations() {
            this.properties.add("operations");
            return this;
        }

        public Builder addChildren(ExpandedChildrenProperties properties) {
            properties.getProperties().stream().map(property -> "children." + property).forEach(property -> this.properties.add((String)property));
            return this;
        }

        public Builder addRestrictions(ExpandedRestrictionProperties properties) {
            properties.getProperties().stream().map(property -> "restrictions." + property).forEach(property -> this.properties.add((String)property));
            return this;
        }

        public Builder addHistory(ExpandedHistoryProperties properties) {
            properties.getProperties().stream().map(property -> "history." + property).forEach(property -> this.properties.add((String)property));
            return this;
        }

        public Builder addAncestors() {
            this.properties.add("ancestors");
            return this;
        }

        public Builder addBody(ContentBodyType type, ExpandedBodyFormatProperties properties) {
            properties.getProperties().stream().map(property -> "body." + type.getIdentifier() + "." + property).forEach(property -> this.properties.add((String)property));
            return this;
        }

        public Builder addVersion() {
            this.properties.add("version");
            return this;
        }

        public Builder addDescendants(ExpandedDescendantsProperties properties) {
            properties.getProperties().stream().map(property -> "descendants." + property).forEach(property -> this.properties.add((String)property));
            return this;
        }

        public Builder addSpace() {
            this.properties.add("space");
            return this;
        }

        public ExpandedContentProperties build() {
            return new ExpandedContentProperties(this);
        }
    }
}

