/*
 * Decompiled with CFR 0.152.
 */
package com.github.crob1140.confluence.content.expand;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExpandedHistoryProperties {
    private final Set<String> properties;

    private ExpandedHistoryProperties(Builder builder) {
        this.properties = Collections.unmodifiableSet(builder.properties);
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public static class Builder {
        private Set<String> properties = new HashSet<String>();

        public Builder addLastUpdated() {
            this.properties.add("lastUpdated");
            return this;
        }

        public Builder addPreviousVersion() {
            this.properties.add("previousVersion");
            return this;
        }

        public Builder addContributors() {
            this.properties.add("contributors");
            return this;
        }

        public Builder addNextVersion() {
            this.properties.add("nextVersion");
            return this;
        }

        public ExpandedHistoryProperties build() {
            return new ExpandedHistoryProperties(this);
        }
    }
}

