/*
 * Decompiled with CFR 0.152.
 */
package com.github.crob1140.confluence.content.expand;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExpandedRestrictionProperties {
    private final Set<String> properties;

    private ExpandedRestrictionProperties(Builder builder) {
        this.properties = Collections.unmodifiableSet(builder.properties);
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public static class Builder {
        private Set<String> properties = new HashSet<String>();

        public Builder addReadUsers() {
            this.properties.add("read.restrictions.user");
            return this;
        }

        public Builder addReadGroups() {
            this.properties.add("read.restrictions.group");
            return this;
        }

        public Builder addUpdateUsers() {
            this.properties.add("update.restrictions.user");
            return this;
        }

        public Builder addUpdateGroups() {
            this.properties.add("update.restrictions.group");
            return this;
        }

        public ExpandedRestrictionProperties build() {
            return new ExpandedRestrictionProperties(this);
        }
    }
}

