/*
 * Decompiled with CFR 0.152.
 */
package com.github.crob1140.confluence.requests;

import com.github.crob1140.confluence.content.Content;
import com.github.crob1140.confluence.content.ContentBody;
import com.github.crob1140.confluence.content.ContentBodyType;
import com.github.crob1140.confluence.content.ContentStatus;
import com.github.crob1140.confluence.content.Label;
import com.github.crob1140.confluence.content.LabelPrefix;
import com.github.crob1140.confluence.content.Metadata;
import com.github.crob1140.confluence.content.StandardContentType;
import com.github.crob1140.confluence.content.expand.ExpandedContentProperties;
import com.github.crob1140.confluence.requests.ConfluenceRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class CreateContentRequest
extends ConfluenceRequest {
    private final ContentStatus responseStatusFilter;
    private final ExpandedContentProperties expandedResponseProperties;
    private Content content;

    private CreateContentRequest(Builder builder) {
        this.responseStatusFilter = builder.responseStatusFilter;
        this.expandedResponseProperties = builder.expandedResponseProperties;
        Content.Builder contentBuilder = new Content.Builder();
        if (builder.ancestorId != null) {
            Content ancestor = new Content.Builder().setId(builder.ancestorId).build();
            contentBuilder.setAncestors(Collections.singletonList(ancestor));
        }
        if (builder.bodyContent != null) {
            contentBuilder.setBody(new ContentBody(builder.bodyType, builder.bodyContent));
        }
        this.content = contentBuilder.setId(builder.id).setTitle(builder.title).setStatus(builder.status).setSpaceKey(builder.spaceKey).setType(builder.type).setMetadata(new Metadata(builder.labels)).build();
    }

    @Override
    public String getRelativePath() {
        return "rest/api/content";
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public Map<String, String> getQueryParams() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.responseStatusFilter != null) {
            queryParams.put("status", this.responseStatusFilter.getIdentifier());
        }
        if (this.expandedResponseProperties != null) {
            queryParams.put("expand", this.expandedResponseProperties.getProperties().stream().collect(Collectors.joining(",")));
        }
        return queryParams;
    }

    @Override
    public Optional<Object> getBodyEntity() {
        return Optional.of(this.content);
    }

    @Override
    public Class<?> getReturnType() {
        return Content.class;
    }

    public static class Builder {
        private ContentStatus responseStatusFilter;
        private ContentBodyType bodyType;
        private String bodyContent;
        private String ancestorId;
        private String id;
        private String spaceKey;
        private ContentStatus status;
        private String title;
        private String type;
        private List<Label> labels = new ArrayList<Label>();
        private ExpandedContentProperties expandedResponseProperties;

        public Builder setAncestor(String id) {
            this.ancestorId = id;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
            return this;
        }

        public Builder setStatus(ContentStatus status) {
            this.status = status;
            return this;
        }

        public Builder setBody(ContentBodyType type, String content) {
            this.bodyType = type;
            this.bodyContent = content;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setType(StandardContentType type) {
            this.type = type.getIdentifier();
            return this;
        }

        public Builder setResponseStatusFilter(ContentStatus status) {
            this.responseStatusFilter = status;
            return this;
        }

        public Builder addLabel(String label) {
            return this.addLabel(label, LabelPrefix.GLOBAL);
        }

        public Builder addLabel(String label, LabelPrefix prefix) {
            this.labels.add(new Label(prefix, label));
            return this;
        }

        public Builder setExpandedResponseProperties(ExpandedContentProperties expandedResponseProperties) {
            this.expandedResponseProperties = expandedResponseProperties;
            return this;
        }

        public CreateContentRequest build() throws IllegalStateException {
            if (this.type == null || this.type.equals("")) {
                throw new IllegalStateException("You must specify the type of content you want to create");
            }
            if (this.spaceKey == null) {
                throw new IllegalStateException("You must specify the space that the content is being created in");
            }
            if (this.status == ContentStatus.DRAFT && this.id == null) {
                throw new IllegalStateException("You must provide an ID when creating a draft");
            }
            return new CreateContentRequest(this);
        }
    }
}

