/*
 * Decompiled with CFR 0.152.
 */
package com.github.crob1140.confluence.requests;

import com.github.crob1140.confluence.content.ContentStatus;
import com.github.crob1140.confluence.content.SortDirection;
import com.github.crob1140.confluence.content.StandardContentType;
import com.github.crob1140.confluence.content.expand.ExpandedContentProperties;
import com.github.crob1140.confluence.requests.ConfluenceRequest;
import com.github.crob1140.confluence.requests.GetContentResponse;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class GetContentRequest
extends ConfluenceRequest {
    private final Integer limit;
    private final String orderByField;
    private final SortDirection orderByDirection;
    private final LocalDate postingDay;
    private final String spaceKey;
    private final Integer start;
    private final ContentStatus status;
    private final String title;
    private final String trigger;
    private final String type;
    private final ExpandedContentProperties expandedProperties;

    private GetContentRequest(Builder builder) {
        this.limit = builder.limit;
        this.orderByField = builder.orderByField;
        this.orderByDirection = builder.orderByDirection;
        this.postingDay = builder.postingDay;
        this.spaceKey = builder.spaceKey;
        this.start = builder.start;
        this.status = builder.status;
        this.title = builder.title;
        this.trigger = builder.trigger;
        this.type = builder.type;
        this.expandedProperties = builder.expandedProperties;
    }

    @Override
    public String getRelativePath() {
        return "rest/api/content";
    }

    @Override
    public String getMethod() {
        return "GET";
    }

    @Override
    public Map<String, String> getQueryParams() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.limit != null) {
            queryParams.put("limit", Integer.toString(this.limit));
        }
        if (this.orderByField != null) {
            queryParams.put("orderBy", this.orderByField + " " + this.orderByDirection.getIdentifier());
        }
        if (this.postingDay != null) {
            queryParams.put("postingDay", this.postingDay.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
        if (this.spaceKey != null) {
            queryParams.put("spaceKey", this.spaceKey);
        }
        if (this.start != null) {
            queryParams.put("start", Integer.toString(this.start));
        }
        if (this.status != null) {
            queryParams.put("status", this.status.getIdentifier());
        }
        if (this.title != null) {
            queryParams.put("title", this.title);
        }
        if (this.trigger != null) {
            queryParams.put("trigger", this.trigger);
        }
        if (this.type != null) {
            queryParams.put("type", this.type);
        }
        if (this.expandedProperties != null) {
            queryParams.put("expand", this.expandedProperties.getProperties().stream().collect(Collectors.joining(",")));
        }
        return queryParams;
    }

    @Override
    public Optional<Object> getBodyEntity() {
        return Optional.empty();
    }

    @Override
    public Class<?> getReturnType() {
        return GetContentResponse.class;
    }

    public static final class Builder {
        private Integer limit;
        private String orderByField;
        private SortDirection orderByDirection;
        private LocalDate postingDay;
        private String spaceKey;
        private Integer start;
        private ContentStatus status;
        private String title;
        private String trigger;
        private String type;
        private ExpandedContentProperties expandedProperties;

        public Builder setLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder orderBy(String field, SortDirection direction) {
            this.orderByField = field;
            this.orderByDirection = direction;
            return this;
        }

        public Builder setPostingDay(LocalDate postingDay) {
            this.postingDay = postingDay;
            return this;
        }

        public Builder setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
            return this;
        }

        public Builder setStartPosition(Integer start) {
            this.start = start;
            return this;
        }

        public Builder setStatus(ContentStatus status) {
            this.status = status;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setTrigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setType(StandardContentType type) {
            this.type = type.getIdentifier();
            return this;
        }

        public Builder setExpandedProperties(ExpandedContentProperties expandedProperties) {
            this.expandedProperties = expandedProperties;
            return this;
        }

        public GetContentRequest build() throws IllegalStateException {
            if (this.limit != null && this.limit <= 0) {
                throw new IllegalStateException("The limit must be a positive number");
            }
            if (this.start != null && this.start <= 0) {
                throw new IllegalStateException("The start position must be a positive number");
            }
            return new GetContentRequest(this);
        }
    }
}

