/*
 * Decompiled with CFR 0.152.
 */
package com.github.crob1140.confluence.requests;

import com.github.crob1140.confluence.content.Content;
import com.github.crob1140.confluence.content.ContentBody;
import com.github.crob1140.confluence.content.ContentBodyType;
import com.github.crob1140.confluence.content.ContentStatus;
import com.github.crob1140.confluence.content.Label;
import com.github.crob1140.confluence.content.LabelPrefix;
import com.github.crob1140.confluence.content.Metadata;
import com.github.crob1140.confluence.content.StandardContentType;
import com.github.crob1140.confluence.content.Version;
import com.github.crob1140.confluence.requests.ConfluenceRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UpdateContentRequest
extends ConfluenceRequest {
    private String id;
    private Content content;

    private UpdateContentRequest(Builder builder) {
        this.id = builder.id;
        Content.Builder contentBuilder = new Content.Builder();
        if (builder.ancestorId != null) {
            Content ancestor = new Content.Builder().setId(builder.ancestorId).build();
            contentBuilder.setAncestors(Collections.singletonList(ancestor));
        }
        if (builder.bodyContent != null) {
            contentBuilder.setBody(new ContentBody(builder.bodyType, builder.bodyContent));
        }
        if (!builder.labels.isEmpty()) {
            contentBuilder.setMetadata(new Metadata(builder.labels));
        }
        this.content = contentBuilder.setTitle(builder.title).setStatus(builder.status).setType(builder.type).setVersion(new Version(builder.versionNumber)).build();
    }

    @Override
    public String getRelativePath() {
        return "rest/api/content/" + this.id;
    }

    @Override
    public String getMethod() {
        return "PUT";
    }

    @Override
    public Map<String, String> getQueryParams() {
        return new HashMap<String, String>();
    }

    @Override
    public Optional<Object> getBodyEntity() {
        return Optional.of(this.content);
    }

    @Override
    public Class<?> getReturnType() {
        return Content.class;
    }

    public static final class Builder {
        private String id;
        private String ancestorId;
        private Integer versionNumber;
        private String type;
        private ContentStatus status;
        private ContentBodyType bodyType;
        private String bodyContent;
        private String title;
        private List<Label> labels = new ArrayList<Label>();

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setAncestor(String id) {
            this.ancestorId = id;
            return this;
        }

        public Builder setVersion(int versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public Builder setStatus(ContentStatus status) {
            this.status = status;
            return this;
        }

        public Builder addLabel(String label) {
            return this.addLabel(label, LabelPrefix.GLOBAL);
        }

        public Builder addLabel(String label, LabelPrefix prefix) {
            this.labels.add(new Label(prefix, label));
            return this;
        }

        public Builder setBody(ContentBodyType type, String content) {
            this.bodyType = type;
            this.bodyContent = content;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setType(StandardContentType type) {
            this.type = type.getIdentifier();
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public UpdateContentRequest build() {
            if (this.id == null) {
                throw new IllegalStateException("You must specify the ID of the content you are trying to update");
            }
            if (this.type == null) {
                throw new IllegalStateException("You must specify the type of content you are trying to update");
            }
            if (this.versionNumber == null) {
                throw new IllegalStateException("You must specify the new version of the content");
            }
            return new UpdateContentRequest(this);
        }
    }
}

