/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service;

import java.util.concurrent.TimeUnit;

public class RateRule {
    private int requests;
    private int per;
    private TimeUnit timeUnit;

    public RateRule(int requests, int per, TimeUnit timeUnit) {
        this.requests = requests;
        this.per = per;
        this.timeUnit = timeUnit;
    }

    public int getRequests() {
        return this.requests;
    }

    public int getPer() {
        return this.per;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long getMilliseconds() {
        return this.timeUnit.toMillis(this.per);
    }

    public String toString() {
        return "[" + RateRule.class.getSimpleName() + " " + this.requests + "/" + this.per + " " + (Object)((Object)this.timeUnit) + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof RateRule) {
            RateRule ro = (RateRule)o;
            return ro.requests == this.requests && ro.getMilliseconds() == this.getMilliseconds();
        }
        return super.equals(o);
    }

    public static RateRule from(String string) {
        String[] parts = string.split(" ");
        if (parts.length != 3) {
            throw new IllegalArgumentException("RateRule.from(String) must be passed a String formatted as REQUESTS PER TimeUnit");
        }
        int requests = Integer.parseInt(parts[0]);
        if (requests < 0) {
            throw new IllegalArgumentException();
        }
        int per = Integer.parseInt(parts[1]);
        if (per < 0) {
            throw new IllegalArgumentException();
        }
        TimeUnit timeUnit = TimeUnit.valueOf(parts[2]);
        return new RateRule(requests, per, timeUnit);
    }

    public static RateRule[] getDevelopmentRates() {
        RateRule[] rules = new RateRule[]{new RateRule(500, 10, TimeUnit.MINUTES), new RateRule(10, 10, TimeUnit.SECONDS)};
        return rules;
    }

    public static RateRule[] getProductionRates() {
        RateRule[] rules = new RateRule[]{new RateRule(180000, 10, TimeUnit.MINUTES), new RateRule(300, 10, TimeUnit.SECONDS)};
        return rules;
    }
}

