/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service;

import java.util.Arrays;
import java.util.HashSet;

public enum Region {
    NORTH_AMERICA("NA"),
    EUROPE_WEST("EUW"),
    EUROPE_NORTHEAST("EUNE"),
    LATIN_AMERICA_NORTH("LAN"),
    LATIN_AMERICA_SOUTH("LAS"),
    BRAZIL("BR"),
    KOREA("KR"),
    OCEANIC("OCE"),
    RUSSIA("RU"),
    TURKEY("TR"),
    PUBLIC_BETA_ENVIRONMENT("PBE");

    private final String text;

    private Region(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text;
    }

    public static Region from(String regionCode) {
        for (Region r : Region.values()) {
            if (!r.text.equals(regionCode)) continue;
            return r;
        }
        return null;
    }

    public static Region[] getExcluding(Region ... excludedRegions) {
        if (excludedRegions == null || excludedRegions.length == 0) {
            return Region.values();
        }
        excludedRegions = Region.removeDuplicates(excludedRegions);
        int excludedLength = 0;
        for (Region r : excludedRegions) {
            if (r == null) continue;
            ++excludedLength;
        }
        int outputLength = Region.values().length - excludedLength;
        if (outputLength < 1) {
            return new Region[0];
        }
        Region[] outputRegions = new Region[outputLength];
        int i = 0;
        for (Region r : Region.values()) {
            boolean excluded;
            boolean bl = excluded = r == null || Region.contains(excludedRegions, r);
            if (excluded) continue;
            outputRegions[i] = r;
            ++i;
        }
        return outputRegions;
    }

    private static Region[] removeDuplicates(Region[] regions) {
        HashSet<Region> alreadyPresent = new HashSet<Region>();
        Region[] whitelist = new Region[regions.length];
        int i = 0;
        for (Region r : regions) {
            if (!alreadyPresent.add(r)) continue;
            whitelist[i++] = r;
        }
        return Arrays.copyOf(whitelist, i);
    }

    private static boolean contains(Region[] regions, Region r) {
        for (Region re : regions) {
            if (re != r) continue;
            return true;
        }
        return false;
    }
}

