/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.dc.riot.lol.rx.service.RateRule;

public final class RiotApiExecutors {
    private static final int DEFAULT_FIXED_POOL_SIZE = 10;

    private RiotApiExecutors() {
    }

    public static Executor newFixedThreadPool(RateRule ... rules) {
        int nThreads = Integer.MAX_VALUE;
        for (RateRule r : rules) {
            if (r.getRequests() >= nThreads) continue;
            nThreads = r.getRequests();
        }
        if (nThreads == Integer.MAX_VALUE) {
            nThreads = 10;
        }
        return Executors.newFixedThreadPool(nThreads);
    }

    public static Executor newFixedThreadPool(ThreadFactory factory, RateRule ... rules) {
        int nThreads = Integer.MAX_VALUE;
        for (RateRule r : rules) {
            if (r.getRequests() >= nThreads) continue;
            nThreads = r.getRequests();
        }
        if (nThreads == Integer.MAX_VALUE) {
            nThreads = 10;
        }
        return Executors.newFixedThreadPool(nThreads, factory);
    }

    public static Executor newCachedThreadPool() {
        return Executors.newCachedThreadPool();
    }

    public static Executor newCachedThreadPool(ThreadFactory factory) {
        return Executors.newCachedThreadPool(factory);
    }
}

