/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.dc.riot.lol.rx.service.RateRule;

public class TicketBucket {
    private long bufferMS = 750L;
    private ArrayList<Bucket> buckets;

    TicketBucket(RateRule ... rules) {
        this.buckets = new ArrayList(rules.length);
        for (int i = 0; i < rules.length; ++i) {
            this.buckets.add(new Bucket(rules[i]));
        }
        Collections.sort(this.buckets, new Comparator<Bucket>(){

            @Override
            public int compare(Bucket lhs, Bucket rhs) {
                if (lhs.getRule().getMilliseconds() > rhs.getRule().getMilliseconds()) {
                    return 1;
                }
                if (lhs.getRule().getMilliseconds() < rhs.getRule().getMilliseconds()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public Ticket[] take() throws InterruptedException {
        Ticket[] tickets = new Ticket[this.buckets.size()];
        for (int i = 0; i < tickets.length; ++i) {
            tickets[i] = this.buckets.get(i).take();
        }
        return tickets;
    }

    public void put(Ticket ... tickets) throws InterruptedException {
        for (Ticket t : tickets) {
            for (Bucket b : this.buckets) {
                if (b.put(t)) break;
            }
        }
    }

    public void setBuffer(int buffer, TimeUnit unit) {
        if (buffer > -1) {
            this.bufferMS = unit.toMillis(buffer);
        }
    }

    public long getBuffer() {
        return this.bufferMS;
    }

    public void stall(long delay, TimeUnit timeUnit) {
        for (Bucket b : this.buckets) {
            b.stall(delay, timeUnit);
        }
    }

    protected long getTime() {
        return System.currentTimeMillis();
    }

    public static class Ticket {
        private UUID name = UUID.randomUUID();
        private int index = -1;
        private UUID parentName;

        private Ticket(UUID parentName, int index) {
            this.parentName = parentName;
            this.index = index;
        }

        public UUID getName() {
            return this.name;
        }

        public UUID getParent() {
            return this.parentName;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "[Ticket " + this.name + "]";
        }
    }

    private class Bucket {
        private UUID name = UUID.randomUUID();
        private ArrayBlockingQueue<Ticket> tickets;
        private RateRule rule;
        private final Object stallLock = new Object();
        private boolean stalled = false;
        private long unstallTime = 0L;
        private Runnable stallTask = () -> {
            while (TicketBucket.this.getTime() < this.unstallTime) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Object object = this.stallLock;
            synchronized (object) {
                this.stalled = false;
                this.stallLock.notifyAll();
            }
        };
        private ScheduledExecutorService librarian;

        Bucket(RateRule rule) {
            this.rule = rule;
            this.tickets = new ArrayBlockingQueue(rule.getRequests());
            try {
                for (int i = 0; i < rule.getRequests(); ++i) {
                    this.tickets.put(new Ticket(this.name, i));
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.librarian = Executors.newScheduledThreadPool(2, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "LIBRARIAN-" + Bucket.this.name);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Ticket take() throws InterruptedException {
            if (this.stalled) {
                Object object = this.stallLock;
                synchronized (object) {
                    if (this.stalled) {
                        this.stallLock.wait();
                    }
                }
            }
            return this.tickets.take();
        }

        boolean put(Ticket t) throws InterruptedException {
            if (t.getParent().equals(this.name)) {
                this.librarian.schedule(() -> {
                    try {
                        this.tickets.put(t);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }, this.rule.getMilliseconds() + TicketBucket.this.bufferMS, TimeUnit.MILLISECONDS);
                return true;
            }
            return false;
        }

        void stall(long delay, TimeUnit unit) {
            this.stalled = true;
            long validTime = TicketBucket.this.getTime() + unit.toMillis(delay);
            if (validTime > this.unstallTime) {
                this.librarian.schedule(this.stallTask, delay, unit);
            }
        }

        RateRule getRule() {
            return this.rule;
        }

        public String toString() {
            return "[" + Bucket.class.getSimpleName() + " " + this.name + " " + this.rule + "]";
        }
    }
}

