/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import com.google.gson.Gson;
import java.io.IOException;
import org.dc.riot.lol.rx.model.championmastery.ChampionMasteryDto;
import org.dc.riot.lol.rx.model.common.PlatformId;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.RiotApi;
import org.dc.riot.lol.rx.service.error.HttpException;
import org.dc.riot.lol.rx.service.interfaces.ApiFactory;
import org.dc.riot.lol.rx.service.interfaces.LowercaseRegion;
import org.dc.riot.lol.rx.service.interfaces.RetrofitCaller;
import org.dc.riot.lol.rx.service.interfaces.RiotApiBase;
import retrofit.Call;
import retrofit.Converter;
import retrofit.GsonConverterFactory;
import retrofit.Retrofit;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;

class ChampionMastery_v1_0
extends RiotApiBase
implements RiotApi.ChampionMastery {
    private Interface inter;

    ChampionMastery_v1_0(ApiKey apiKey, Region region) {
        super(apiKey, region);
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://" + new LowercaseRegion(region) + ".api.pvp.net").client(this.client).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)ApiFactory.getGson())).build();
        this.inter = (Interface)retrofit.create(Interface.class);
    }

    @Override
    public float getVersion() {
        return 1.0f;
    }

    @Override
    public ChampionMasteryDto getPlayerChampionMastery(long summonerId, long championId) throws IOException, HttpException {
        return (ChampionMasteryDto)RetrofitCaller.processCall(() -> this.inter.getPlayerChampionMastery(PlatformId.from(this.region), summonerId, championId, this.apiKey));
    }

    @Override
    public ChampionMasteryDto[] getPlayerAllMastery(long summonerId) throws IOException, HttpException {
        return (ChampionMasteryDto[])RetrofitCaller.processCall(() -> this.inter.getPlayerAllMastery(PlatformId.from(this.region), summonerId, this.apiKey));
    }

    @Override
    public int getMasteryScore(long summonerId) throws IOException, HttpException {
        return (Integer)RetrofitCaller.processCall(() -> this.inter.getMasteryScore(PlatformId.from(this.region), summonerId, this.apiKey));
    }

    @Override
    public ChampionMasteryDto[] getTopChampions(long summonerId, int count) throws IOException, HttpException {
        return (ChampionMasteryDto[])RetrofitCaller.processCall(() -> this.inter.getTopChampions(PlatformId.from(this.region), summonerId, this.apiKey));
    }

    private static interface Interface {
        @GET(value="/championmastery/location/{platformId}/player/{summonerId}/champion/{championId}")
        public Call<ChampionMasteryDto> getPlayerChampionMastery(@Path(value="platformId") PlatformId var1, @Path(value="summonerId") long var2, @Path(value="championId") long var4, @Query(value="api_key") ApiKey var6);

        @GET(value="/championmastery/location/{platformId}/player/{summonerId}/champions")
        public Call<ChampionMasteryDto[]> getPlayerAllMastery(@Path(value="platformId") PlatformId var1, @Path(value="summonerId") long var2, @Query(value="api_key") ApiKey var4);

        @GET(value="/championmastery/location/{platformId}/player/{summonerId}/score")
        public Call<Integer> getMasteryScore(@Path(value="platformId") PlatformId var1, @Path(value="summonerId") long var2, @Query(value="api_key") ApiKey var4);

        @GET(value="/championmastery/location/{platformId}/player/{summonerId}/topchampions")
        public Call<ChampionMasteryDto[]> getTopChampions(@Path(value="platformId") PlatformId var1, @Path(value="summonerId") long var2, @Query(value="api_key") ApiKey var4);
    }
}

