/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import com.google.gson.Gson;
import java.io.IOException;
import org.dc.riot.lol.rx.model.champion.ChampDto;
import org.dc.riot.lol.rx.model.champion.ChampListDto;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.RiotApi;
import org.dc.riot.lol.rx.service.error.HttpException;
import org.dc.riot.lol.rx.service.interfaces.ApiFactory;
import org.dc.riot.lol.rx.service.interfaces.LowercaseRegion;
import org.dc.riot.lol.rx.service.interfaces.RetrofitCaller;
import org.dc.riot.lol.rx.service.interfaces.RiotApiBase;
import retrofit.Call;
import retrofit.Converter;
import retrofit.GsonConverterFactory;
import retrofit.Retrofit;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;

class Champion_v1_2
extends RiotApiBase
implements RiotApi.Champion {
    private Interface inter;

    Champion_v1_2(ApiKey apiKey, Region region) {
        super(apiKey, region);
        Retrofit ra = new Retrofit.Builder().baseUrl("https://" + new LowercaseRegion(region) + ".api.pvp.net").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)ApiFactory.getGson())).client(this.client).build();
        this.inter = (Interface)ra.create(Interface.class);
    }

    @Override
    public float getVersion() {
        return 1.2f;
    }

    @Override
    public ChampListDto getChampions(boolean freeToPlay) throws IOException, HttpException {
        return (ChampListDto)RetrofitCaller.processCall(() -> this.inter.getChampions(this.region, this.apiKey, freeToPlay));
    }

    @Override
    public ChampDto getChampion(long championId) throws IOException, HttpException {
        return (ChampDto)RetrofitCaller.processCall(() -> this.inter.getChampion(this.region, championId, this.apiKey));
    }

    private static interface Interface {
        @GET(value="/api/lol/{region}/v1.2/champion")
        public Call<ChampListDto> getChampions(@Path(value="region") Region var1, @Query(value="api_key") ApiKey var2);

        @GET(value="/api/lol/{region}/v1.2/champion")
        public Call<ChampListDto> getChampions(@Path(value="region") Region var1, @Query(value="api_key") ApiKey var2, @Query(value="freeToPlay") boolean var3);

        @GET(value="/api/lol/{region}/v1.2/champion/{championId}")
        public Call<ChampDto> getChampion(@Path(value="region") Region var1, @Path(value="championId") long var2, @Query(value="api_key") ApiKey var4);
    }
}

