/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Map;
import org.dc.riot.lol.rx.model.common.QueueType;
import org.dc.riot.lol.rx.model.league.LeagueDto;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.RiotApi;
import org.dc.riot.lol.rx.service.error.HttpException;
import org.dc.riot.lol.rx.service.interfaces.ApiFactory;
import org.dc.riot.lol.rx.service.interfaces.CSA;
import org.dc.riot.lol.rx.service.interfaces.LowercaseRegion;
import org.dc.riot.lol.rx.service.interfaces.RetrofitCaller;
import org.dc.riot.lol.rx.service.interfaces.RiotApiBase;
import retrofit.Call;
import retrofit.Converter;
import retrofit.GsonConverterFactory;
import retrofit.Retrofit;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;

class League_v2_5
extends RiotApiBase
implements RiotApi.League {
    private Interface inter;

    League_v2_5(ApiKey apiKey, Region region) {
        super(apiKey, region);
        Retrofit ra = new Retrofit.Builder().baseUrl("https://" + region.toString().toLowerCase() + ".api.pvp.net").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)ApiFactory.getGson())).client(this.client).build();
        this.inter = (Interface)ra.create(Interface.class);
    }

    @Override
    public float getVersion() {
        return 2.5f;
    }

    @Override
    public Map<String, LeagueDto[]> getBySummoners(long ... summonerIds) throws IOException, HttpException {
        return RetrofitCaller.processCall(() -> this.inter.getBySummoners(new LowercaseRegion(this.region), new CSA.Long(summonerIds), this.apiKey), null, 400);
    }

    @Override
    public Map<String, LeagueDto[]> getBySummonerEntries(long ... summonerIds) throws IOException, HttpException {
        return RetrofitCaller.processCall(() -> this.inter.getBySummonerEntries(new LowercaseRegion(this.region), new CSA.Long(summonerIds), this.apiKey), null, 400);
    }

    @Override
    public Map<String, LeagueDto[]> getByTeams(String ... teamIds) throws IOException, HttpException {
        return RetrofitCaller.processCall(() -> this.inter.getByTeams(new LowercaseRegion(this.region), new CSA<String>(teamIds), this.apiKey), null, 400);
    }

    @Override
    public Map<String, LeagueDto[]> getByTeamEntries(String ... teamIds) throws IOException, HttpException {
        return RetrofitCaller.processCall(() -> this.inter.getByTeamEntries(new LowercaseRegion(this.region), new CSA<String>(teamIds), this.apiKey), null, 400);
    }

    @Override
    public LeagueDto getChallenger(QueueType.ChallengerMaster queue) throws IOException, HttpException {
        return RetrofitCaller.processCall(() -> this.inter.getChallenger(new LowercaseRegion(this.region), this.apiKey, queue), null, 400);
    }

    @Override
    public LeagueDto getMaster(QueueType.ChallengerMaster queue) throws IOException, HttpException {
        return RetrofitCaller.processCall(() -> this.inter.getMaster(new LowercaseRegion(this.region), this.apiKey, queue), null, 400);
    }

    private static interface Interface {
        @GET(value="/api/lol/{region}/v2.5/league/by-summoner/{summonerIds}")
        public Call<Map<String, LeagueDto[]>> getBySummoners(@Path(value="region") LowercaseRegion var1, @Path(value="summonerIds") CSA.Long var2, @Query(value="api_key") ApiKey var3);

        @GET(value="/api/lol/{region}/v2.5/league/by-summoner/{summonerIds}/entry")
        public Call<Map<String, LeagueDto[]>> getBySummonerEntries(@Path(value="region") LowercaseRegion var1, @Path(value="summonerIds") CSA.Long var2, @Query(value="api_key") ApiKey var3);

        @GET(value="/api/lol/{region}/v2.5/league/by-team/{teamIds}")
        public Call<Map<String, LeagueDto[]>> getByTeams(@Path(value="region") LowercaseRegion var1, @Path(value="teamIds") CSA<String> var2, @Query(value="api_key") ApiKey var3);

        @GET(value="/api/lol/{region}/v2.5/league/by-team/{teamIds}/entry")
        public Call<Map<String, LeagueDto[]>> getByTeamEntries(@Path(value="region") LowercaseRegion var1, @Path(value="teamIds") CSA<String> var2, @Query(value="api_key") ApiKey var3);

        @GET(value="/api/lol/{region}/v2.5/league/challenger")
        public Call<LeagueDto> getChallenger(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2, @Query(value="type") QueueType.ChallengerMaster var3);

        @GET(value="/api/lol/{region}/v2.5/league/master")
        public Call<LeagueDto> getMaster(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2, @Query(value="type") QueueType.ChallengerMaster var3);
    }
}

