/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import com.google.gson.Gson;
import java.io.IOException;
import org.dc.riot.lol.rx.model.common.RankedQueue;
import org.dc.riot.lol.rx.model.common.Season;
import org.dc.riot.lol.rx.model.match.MatchListDto;
import org.dc.riot.lol.rx.model.match.MatchReference;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.RiotApi;
import org.dc.riot.lol.rx.service.error.HttpException;
import org.dc.riot.lol.rx.service.interfaces.ApiFactory;
import org.dc.riot.lol.rx.service.interfaces.CSA;
import org.dc.riot.lol.rx.service.interfaces.LowercaseRegion;
import org.dc.riot.lol.rx.service.interfaces.RetrofitCaller;
import org.dc.riot.lol.rx.service.interfaces.RiotApiBase;
import retrofit.Call;
import retrofit.Converter;
import retrofit.GsonConverterFactory;
import retrofit.Retrofit;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;

class MatchList_v2_2
extends RiotApiBase
implements RiotApi.MatchList {
    private Interface inter;

    MatchList_v2_2(ApiKey apiKey, Region region) {
        super(apiKey, region);
        Retrofit ra = new Retrofit.Builder().baseUrl("https://" + region.toString().toLowerCase() + ".api.pvp.net").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)ApiFactory.getGson())).client(this.client).build();
        this.inter = (Interface)ra.create(Interface.class);
    }

    @Override
    public float getVersion() {
        return 2.2f;
    }

    @Override
    public MatchListDto getMatchList(long summonerId, long[] championIds, RankedQueue[] rankedQueues, Season[] seasons, long beginTime, long endTime, int beginIndex, int endIndex) throws IOException, HttpException {
        CSA.Long champIdParam = championIds != null && championIds.length > 0 ? new CSA.Long(championIds) : null;
        Long beginTimeParam = beginTime > -1L ? new Long(beginTime) : null;
        Long endTimeParam = endTime > -1L ? new Long(endTime) : null;
        Integer beginIndexParam = beginIndex > -1 ? new Integer(beginIndex) : null;
        Integer endIndexParam = endTime > -1L ? new Integer(endIndex) : null;
        return RetrofitCaller.processCall(() -> this.inter.getMatchList(new LowercaseRegion(this.region), summonerId, this.apiKey, champIdParam, new CSA<RankedQueue>(rankedQueues), new CSA<Season>(seasons), beginTimeParam, endTimeParam, beginIndexParam, endIndexParam), dto -> {
            for (MatchReference mr : dto.getMatches()) {
                mr.setRegion(this.region);
            }
            return dto;
        });
    }

    private static interface Interface {
        @GET(value="/api/lol/{region}/v2.2/matchlist/by-summoner/{summonerId}")
        public Call<MatchListDto> getMatchList(@Path(value="region") LowercaseRegion var1, @Path(value="summonerId") long var2, @Query(value="api_key") ApiKey var4, @Query(value="championIds") CSA.Long var5, @Query(value="rankedQueues") CSA<RankedQueue> var6, @Query(value="seasons") CSA<Season> var7, @Query(value="beginTime") Long var8, @Query(value="endTime") Long var9, @Query(value="beginIndex") Integer var10, @Query(value="endIndex") Integer var11);
    }
}

