/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import java.io.IOException;
import org.dc.riot.lol.rx.service.error.HttpException;
import org.dc.riot.lol.rx.service.interfaces.Completer;
import retrofit.Call;
import retrofit.Response;

@FunctionalInterface
interface RetrofitCaller<T> {
    public static final boolean DEBUG = false;
    public static final Object PRINT_LOCK = new Object();

    public Call<T> call();

    public static <T> T processCall(RetrofitCaller<T> caller) throws IOException, HttpException {
        Call<T> call = caller.call();
        Response response = call.execute();
        switch (response.code()) {
            case 200: {
                return (T)response.body();
            }
            case 204: {
                return (T)response.body();
            }
        }
        throw new HttpException(response.code(), response.headers().toMultimap());
    }

    public static <T> T processCall(RetrofitCaller<T> caller, T defaultValue, int ... passCodes) throws IOException, HttpException {
        Call<T> call = caller.call();
        Response response = call.execute();
        switch (response.code()) {
            case 200: {
                return (T)response.body();
            }
            case 204: {
                return null;
            }
        }
        if (passCodes != null) {
            for (int code : passCodes) {
                if (code != response.code()) continue;
                return defaultValue;
            }
        }
        throw new HttpException(response.code(), response.headers().toMultimap());
    }

    public static <T> T processCall(RetrofitCaller<T> caller, Completer<T> completer) throws IOException, HttpException {
        T t = RetrofitCaller.processCall(caller);
        return completer.fill(t);
    }
}

