/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import com.google.gson.Gson;
import java.io.IOException;
import org.dc.riot.lol.rx.model.staticdata.ChampionDto;
import org.dc.riot.lol.rx.model.staticdata.ChampionListDto;
import org.dc.riot.lol.rx.model.staticdata.ItemDto;
import org.dc.riot.lol.rx.model.staticdata.ItemListDto;
import org.dc.riot.lol.rx.model.staticdata.LanguageStringsDto;
import org.dc.riot.lol.rx.model.staticdata.MapDataDto;
import org.dc.riot.lol.rx.model.staticdata.MasteryDto;
import org.dc.riot.lol.rx.model.staticdata.MasteryListDto;
import org.dc.riot.lol.rx.model.staticdata.RealmDto;
import org.dc.riot.lol.rx.model.staticdata.RuneDto;
import org.dc.riot.lol.rx.model.staticdata.RuneListDto;
import org.dc.riot.lol.rx.model.staticdata.SummonerSpellDto;
import org.dc.riot.lol.rx.model.staticdata.SummonerSpellListDto;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.RiotApi;
import org.dc.riot.lol.rx.service.error.HttpException;
import org.dc.riot.lol.rx.service.interfaces.ApiFactory;
import org.dc.riot.lol.rx.service.interfaces.CSA;
import org.dc.riot.lol.rx.service.interfaces.LowercaseRegion;
import org.dc.riot.lol.rx.service.interfaces.RetrofitCaller;
import org.dc.riot.lol.rx.service.interfaces.RiotApiBase;
import org.dc.riot.lol.rx.service.request.ChampDataTag;
import org.dc.riot.lol.rx.service.request.ChampListDataTag;
import org.dc.riot.lol.rx.service.request.ItemDataTag;
import org.dc.riot.lol.rx.service.request.ItemListDataTag;
import org.dc.riot.lol.rx.service.request.MasteryDataTag;
import org.dc.riot.lol.rx.service.request.MasteryListDataTag;
import org.dc.riot.lol.rx.service.request.RuneDataTag;
import org.dc.riot.lol.rx.service.request.RuneListDataTag;
import org.dc.riot.lol.rx.service.request.SpellDataTag;
import retrofit.Call;
import retrofit.Converter;
import retrofit.GsonConverterFactory;
import retrofit.Retrofit;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;

class StaticData_v1_2
extends RiotApiBase
implements RiotApi.StaticData {
    private Interface inter;

    StaticData_v1_2(ApiKey apiKey, Region region) {
        super(apiKey, region);
        Retrofit ra = new Retrofit.Builder().client(this.client).baseUrl("https://global.api.pvp.net").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)ApiFactory.getGson())).build();
        this.inter = (Interface)ra.create(Interface.class);
    }

    @Override
    public float getVersion() {
        return 1.2f;
    }

    @Override
    public RiotApi.RateType getRateType() {
        return RiotApi.RateType.SERVICE;
    }

    @Override
    public ChampionListDto getChampions(boolean dataById, String version, String locale, ChampListDataTag ... champData) throws IOException, HttpException {
        return (ChampionListDto)RetrofitCaller.processCall(() -> this.inter.getChampions(new LowercaseRegion(this.region), this.apiKey, dataById, locale, version, new CSA<ChampListDataTag>(champData)));
    }

    @Override
    public ChampionDto getChampion(long champId, String version, String locale, ChampDataTag ... champData) throws IOException, HttpException {
        return (ChampionDto)RetrofitCaller.processCall(() -> this.inter.getChampion(new LowercaseRegion(this.region), champId, this.apiKey, locale, version, new CSA<ChampDataTag>(champData)));
    }

    @Override
    public ItemListDto getItems(String version, String locale, ItemListDataTag ... itemListData) throws IOException, HttpException {
        return (ItemListDto)RetrofitCaller.processCall(() -> this.inter.getItems(new LowercaseRegion(this.region), this.apiKey, locale, version, new CSA<ItemListDataTag>(itemListData)));
    }

    @Override
    public ItemDto getItem(long itemId, String version, String locale, ItemDataTag ... itemData) throws IOException, HttpException {
        return (ItemDto)RetrofitCaller.processCall(() -> this.inter.getItem(new LowercaseRegion(this.region), itemId, this.apiKey, locale, version, new CSA<ItemDataTag>(itemData)));
    }

    @Override
    public LanguageStringsDto getLanguageStrings(String version, String locale) throws IOException, HttpException {
        return (LanguageStringsDto)RetrofitCaller.processCall(() -> this.inter.getLanguageStrings(new LowercaseRegion(this.region), this.apiKey, locale, version));
    }

    @Override
    public String[] getLocales() throws IOException, HttpException {
        return (String[])RetrofitCaller.processCall(() -> this.inter.getLocales(new LowercaseRegion(this.region), this.apiKey));
    }

    @Override
    public MapDataDto getMap(String version, String locale) throws IOException, HttpException {
        return (MapDataDto)RetrofitCaller.processCall(() -> this.inter.getMap(new LowercaseRegion(this.region), this.apiKey, locale, version));
    }

    @Override
    public MasteryListDto getMasteries(String version, String locale, MasteryListDataTag ... masteryListData) throws IOException, HttpException {
        return (MasteryListDto)RetrofitCaller.processCall(() -> this.inter.getMasteries(new LowercaseRegion(this.region), this.apiKey, locale, version, new CSA<MasteryListDataTag>(masteryListData)));
    }

    @Override
    public MasteryDto getMastery(long masteryId, String version, String locale, MasteryDataTag ... masteryData) throws IOException, HttpException {
        return (MasteryDto)RetrofitCaller.processCall(() -> this.inter.getMastery(new LowercaseRegion(this.region), masteryId, this.apiKey, locale, version, new CSA<MasteryDataTag>(masteryData)));
    }

    @Override
    public RealmDto getRealm() throws IOException, HttpException {
        return (RealmDto)RetrofitCaller.processCall(() -> this.inter.getRealm(new LowercaseRegion(this.region), this.apiKey));
    }

    @Override
    public RuneListDto getRunes(String version, String locale, RuneListDataTag ... runeListData) throws IOException, HttpException {
        return (RuneListDto)RetrofitCaller.processCall(() -> this.inter.getRunes(new LowercaseRegion(this.region), this.apiKey, locale, version, new CSA<RuneListDataTag>(runeListData)));
    }

    @Override
    public RuneDto getRune(long id, String version, String locale, RuneDataTag ... runeData) throws IOException, HttpException {
        return (RuneDto)RetrofitCaller.processCall(() -> this.inter.getRune(new LowercaseRegion(this.region), id, this.apiKey, locale, version, new CSA<RuneDataTag>(runeData)));
    }

    @Override
    public SummonerSpellListDto getSummonerSpells(boolean dataById, String version, String locale, SpellDataTag ... spellData) throws IOException, HttpException {
        return (SummonerSpellListDto)RetrofitCaller.processCall(() -> this.inter.getSummonerSpells(new LowercaseRegion(this.region), this.apiKey, dataById, locale, version, new CSA<SpellDataTag>(spellData)));
    }

    @Override
    public SummonerSpellDto getSummonerSpell(long summonerSpellId, String version, String locale, SpellDataTag ... spellData) throws IOException, HttpException {
        return (SummonerSpellDto)RetrofitCaller.processCall(() -> this.inter.getSummonerSpell(new LowercaseRegion(this.region), summonerSpellId, this.apiKey, locale, version, new CSA<SpellDataTag>(spellData)));
    }

    @Override
    public String[] getVersions() throws IOException, HttpException {
        return (String[])RetrofitCaller.processCall(() -> this.inter.getVersions(new LowercaseRegion(this.region), this.apiKey));
    }

    private static interface Interface {
        @GET(value="/api/lol/static-data/{region}/v1.2/champion")
        public Call<ChampionListDto> getChampions(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2, @Query(value="dataById") boolean var3, @Query(value="locale") String var4, @Query(value="version") String var5, @Query(value="champData") CSA<ChampListDataTag> var6);

        @GET(value="/api/lol/static-data/{region}/v1.2/champion/{id}")
        public Call<ChampionDto> getChampion(@Path(value="region") LowercaseRegion var1, @Path(value="id") long var2, @Query(value="api_key") ApiKey var4, @Query(value="locale") String var5, @Query(value="version") String var6, @Query(value="champData") CSA<ChampDataTag> var7);

        @GET(value="/api/lol/static-data/{region}/v1.2/item")
        public Call<ItemListDto> getItems(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2, @Query(value="locale") String var3, @Query(value="version") String var4, @Query(value="itemListData") CSA<ItemListDataTag> var5);

        @GET(value="/api/lol/static-data/{region}/v1.2/item/{id}")
        public Call<ItemDto> getItem(@Path(value="region") LowercaseRegion var1, @Path(value="id") long var2, @Query(value="api_key") ApiKey var4, @Query(value="locale") String var5, @Query(value="version") String var6, @Query(value="itemData") CSA<ItemDataTag> var7);

        @GET(value="/api/lol/static-data/{region}/v1.2/language-strings")
        public Call<LanguageStringsDto> getLanguageStrings(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2, @Query(value="locale") String var3, @Query(value="version") String var4);

        @GET(value="/api/lol/static-data/{region}/v1.2/languages")
        public Call<String[]> getLocales(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2);

        @GET(value="/api/lol/static-data/{region}/v1.2/map")
        public Call<MapDataDto> getMap(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2, @Query(value="locale") String var3, @Query(value="version") String var4);

        @GET(value="/api/lol/static-data/{region}/v1.2/mastery")
        public Call<MasteryListDto> getMasteries(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2, @Query(value="locale") String var3, @Query(value="version") String var4, @Query(value="masteryListData") CSA<MasteryListDataTag> var5);

        @GET(value="/api/lol/static-data/{region}/v1.2/mastery/{id}")
        public Call<MasteryDto> getMastery(@Path(value="region") LowercaseRegion var1, @Path(value="id") long var2, @Query(value="api_key") ApiKey var4, @Query(value="locale") String var5, @Query(value="version") String var6, @Query(value="masteryData") CSA<MasteryDataTag> var7);

        @GET(value="/api/lol/static-data/{region}/v1.2/realm")
        public Call<RealmDto> getRealm(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2);

        @GET(value="/api/lol/static-data/{region}/v1.2/rune")
        public Call<RuneListDto> getRunes(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2, @Query(value="locale") String var3, @Query(value="version") String var4, @Query(value="runeListData") CSA<RuneListDataTag> var5);

        @GET(value="/api/lol/static-data/{region}/v1.2/rune/{id}")
        public Call<RuneDto> getRune(@Path(value="region") LowercaseRegion var1, @Path(value="id") long var2, @Query(value="api_key") ApiKey var4, @Query(value="locale") String var5, @Query(value="version") String var6, @Query(value="runeData") CSA<RuneDataTag> var7);

        @GET(value="/api/lol/static-data/{region}/v1.2/summoner-spell")
        public Call<SummonerSpellListDto> getSummonerSpells(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2, @Query(value="dataById") boolean var3, @Query(value="locale") String var4, @Query(value="version") String var5, @Query(value="spellData") CSA<SpellDataTag> var6);

        @GET(value="/api/lol/static-data/{region}/v1.2/summoner-spell/{id}")
        public Call<SummonerSpellDto> getSummonerSpell(@Path(value="region") LowercaseRegion var1, @Path(value="id") long var2, @Query(value="api_key") ApiKey var4, @Query(value="locale") String var5, @Query(value="version") String var6, @Query(value="spellData") CSA<SpellDataTag> var7);

        @GET(value="/api/lol/static-data/{region}/v1.2/versions")
        public Call<String[]> getVersions(@Path(value="region") LowercaseRegion var1, @Query(value="api_key") ApiKey var2);
    }
}

