/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Scanner;
import org.dc.riot.lol.rx.service.RateRule;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.TicketBucket;

public class ApiKey {
    private static final String DEVELOPMENT = "DEV";
    private static final String PRODUCTION = "PROD";
    private final String key;
    private final RateRule[] rules;
    private EnumMap<Region, TicketBucket> buckets = new EnumMap(Region.class);

    public ApiKey(String key, RateRule ... rules) {
        this.key = key;
        this.rules = rules;
    }

    public RateRule[] getRules() {
        return this.rules;
    }

    public synchronized TicketBucket getTicketBucket(Region region) {
        TicketBucket tb = this.buckets.get((Object)region);
        if (tb == null) {
            tb = new TicketBucket(this.rules);
            this.buckets.put(region, tb);
        }
        return tb;
    }

    public String toString() {
        return this.key;
    }

    public static ApiKey[] loadApiKeys() throws FileNotFoundException {
        return ApiKey.loadApiKeys(new File("./API_KEY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiKey[] loadApiKeys(File file) throws FileNotFoundException {
        ArrayList<ApiKey> keys = new ArrayList<ApiKey>();
        try (Scanner scanner = null;){
            scanner = new Scanner(new BufferedInputStream(new FileInputStream(file)));
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if ("".equals(line.trim()) || line.startsWith("#")) continue;
                String key = line.trim();
                String keyDetails = scanner.nextLine().trim();
                RateRule[] rules = null;
                rules = DEVELOPMENT.equals(keyDetails) ? RateRule.getDevelopmentRates() : (PRODUCTION.equals(keyDetails) ? RateRule.getProductionRates() : ApiKey.parseRules(keyDetails, scanner));
                keys.add(new ApiKey(key, rules));
            }
        }
        return keys.toArray(new ApiKey[keys.size()]);
    }

    private static RateRule[] parseRules(String keyDetails, Scanner scanner) {
        String line;
        ArrayList<RateRule> parsedRules = new ArrayList<RateRule>();
        parsedRules.add(RateRule.from(keyDetails));
        while (scanner.hasNextLine() && !"".equals(line = scanner.nextLine().trim()) && !line.startsWith("#")) {
            parsedRules.add(RateRule.from(line));
        }
        return parsedRules.toArray(new RateRule[parsedRules.size()]);
    }
}

