/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.RiotApi;

class RetryInterceptor
implements Interceptor {
    private ApiKey apiKey;
    private Region region;
    private long wait = 2000L;
    private int retryCount = 5;

    RetryInterceptor(ApiKey apiKey, Region region) {
        this.apiKey = apiKey;
        this.region = region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = null;
        boolean success = false;
        int tryCount = 0;
        while (!success && tryCount < this.retryCount) {
            try {
                response = chain.proceed(request);
                if (response.code() != 429) break;
                String type = response.header("X-Rate-Limit-Type");
                String waitSeconds = response.header("Retry-After");
                RiotApi.RateType rt = RiotApi.RateType.from(type);
                switch (rt) {
                    case PERSONAL: {
                        if (waitSeconds == null) {
                            this.apiKey.getTicketBucket(this.region).stall(this.wait, TimeUnit.MILLISECONDS);
                            try {
                                Thread.sleep(this.wait);
                            }
                            catch (InterruptedException e) {}
                            break;
                        }
                        try {
                            int wait = Integer.parseInt(waitSeconds);
                            this.apiKey.getTicketBucket(this.region).stall(wait, TimeUnit.SECONDS);
                            try {
                                Thread.sleep(TimeUnit.SECONDS.toMillis(wait));
                            }
                            catch (InterruptedException e) {
                            }
                        }
                        catch (NumberFormatException e) {
                            this.apiKey.getTicketBucket(this.region).stall(this.wait, TimeUnit.MILLISECONDS);
                            try {
                                Thread.sleep(this.wait);
                            }
                            catch (InterruptedException ex) {}
                        }
                        break;
                    }
                    case SERVICE: {
                        if (waitSeconds == null) {
                            try {
                                Thread.sleep(this.wait);
                            }
                            catch (InterruptedException e) {}
                            break;
                        }
                        try {
                            int wait = Integer.parseInt(waitSeconds);
                            try {
                                Thread.sleep(TimeUnit.SECONDS.toMillis(wait));
                            }
                            catch (InterruptedException e) {
                            }
                        }
                        catch (NumberFormatException e) {
                            try {
                                Thread.sleep(this.wait);
                            }
                            catch (InterruptedException ex) {}
                        }
                        break;
                    }
                    default: {
                        try {
                            Thread.sleep(this.wait);
                            break;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                success = response.isSuccessful();
            }
            catch (Exception e) {}
            continue;
            finally {
                ++tryCount;
            }
        }
        return response;
    }

    void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    void setWait(long wait) {
        this.wait = wait;
    }
}

