/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import java.net.Proxy;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.RiotApi;
import org.dc.riot.lol.rx.service.interfaces.RetryInterceptor;
import org.dc.riot.lol.rx.service.interfaces.TicketedInterceptor;

abstract class RiotApiBase
implements RiotApi {
    protected final ApiKey apiKey;
    protected final Region region;
    protected final OkHttpClient client;
    private TicketedInterceptor ticketer = null;
    private RetryInterceptor retry = null;
    private int retryCount = 5;
    private boolean printUrls = false;

    RiotApiBase(ApiKey apiKey, Region region) {
        this.apiKey = apiKey;
        this.region = region;
        this.client = new OkHttpClient();
        this.client.interceptors().add(chain -> {
            Request request = chain.request();
            if (this.printUrls) {
                System.out.println(request.urlString());
            }
            return chain.proceed(request);
        });
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public ApiKey getApiKey() {
        return this.apiKey;
    }

    @Override
    public void setProxy(Proxy proxy) {
        this.client.setProxy(proxy);
    }

    @Override
    public void setPrintUrl(boolean printUrls) {
        this.printUrls = printUrls;
    }

    @Override
    public synchronized void setAutoRetry(boolean autoRetry) {
        if (autoRetry && this.retry == null && this.client != null) {
            this.retry = new RetryInterceptor(this.apiKey, this.region);
            this.client.interceptors().add(this.retry);
            this.retry.setRetryCount(this.retryCount);
        } else if (!autoRetry && this.retry != null && this.client != null) {
            this.client.interceptors().remove(this.retry);
            this.retry = null;
        }
    }

    @Override
    public synchronized void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
        if (this.retry != null) {
            this.retry.setRetryCount(retryCount);
        }
    }

    @Override
    public synchronized void setRateControl(boolean control) {
        if (control) {
            if (this.ticketer == null) {
                this.ticketer = new TicketedInterceptor(this.apiKey.getTicketBucket(this.region));
                if (this.client != null) {
                    this.client.interceptors().add(0, this.ticketer);
                }
            }
        } else {
            if (this.ticketer != null && this.client != null) {
                this.client.interceptors().remove(this.ticketer);
            }
            this.ticketer = null;
        }
    }
}

