/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Map;
import org.dc.riot.lol.rx.model.summoner.MasteryPagesDto;
import org.dc.riot.lol.rx.model.summoner.RunePagesDto;
import org.dc.riot.lol.rx.model.summoner.SummonerDto;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.RiotApi;
import org.dc.riot.lol.rx.service.error.HttpException;
import org.dc.riot.lol.rx.service.interfaces.ApiFactory;
import org.dc.riot.lol.rx.service.interfaces.CSA;
import org.dc.riot.lol.rx.service.interfaces.RetrofitCaller;
import org.dc.riot.lol.rx.service.interfaces.RiotApiBase;
import retrofit.Call;
import retrofit.Converter;
import retrofit.GsonConverterFactory;
import retrofit.Retrofit;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;

class Summoner_v1_4
extends RiotApiBase
implements RiotApi.Summoner {
    private Interface inter;

    Summoner_v1_4(ApiKey apiKey, Region region) {
        super(apiKey, region);
        Retrofit ra = new Retrofit.Builder().baseUrl("https://" + region.toString().toLowerCase() + ".api.pvp.net").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)ApiFactory.getGson())).client(this.client).build();
        this.inter = (Interface)ra.create(Interface.class);
    }

    @Override
    public float getVersion() {
        return 1.4f;
    }

    @Override
    public Map<String, SummonerDto> getByNames(String ... summonerNames) throws IOException, HttpException {
        return RetrofitCaller.processCall(() -> {
            String[] encodedNames = new String[summonerNames.length];
            for (int i = 0; i < encodedNames.length; ++i) {
                encodedNames[i] = RiotApi.Summoner.encodeName(summonerNames[i]);
            }
            return this.inter.getByNames(this.region, new CSA<String>(encodedNames), this.apiKey);
        }, dto -> {
            for (SummonerDto s : dto.values()) {
                s.setRegion(this.region);
            }
            return dto;
        });
    }

    @Override
    public Map<String, SummonerDto> getByIds(long ... summonerIds) throws IOException, HttpException {
        return RetrofitCaller.processCall(() -> this.inter.getByIds(this.region, new CSA.Long(summonerIds), this.apiKey), dto -> {
            for (SummonerDto s : dto.values()) {
                s.setRegion(this.region);
            }
            return dto;
        });
    }

    @Override
    public Map<String, SummonerDto> getByAccounts(long ... accountIds) throws IOException, HttpException {
        return RetrofitCaller.processCall(() -> this.inter.getByAccounts(this.region, new CSA.Long(accountIds), this.apiKey), dto -> {
            for (SummonerDto s : dto.values()) {
                s.setRegion(this.region);
            }
            return dto;
        });
    }

    @Override
    public Map<String, MasteryPagesDto> getMasteries(long ... summonerIds) throws IOException, HttpException {
        return (Map)RetrofitCaller.processCall(() -> this.inter.getMasteries(this.region, new CSA.Long(summonerIds), this.apiKey));
    }

    @Override
    public Map<String, String> getNames(long ... summonerIds) throws IOException, HttpException {
        return (Map)RetrofitCaller.processCall(() -> this.inter.getNames(this.region, new CSA.Long(summonerIds), this.apiKey));
    }

    @Override
    public Map<String, RunePagesDto> getRunes(long ... summonerIds) throws IOException, HttpException {
        return (Map)RetrofitCaller.processCall(() -> this.inter.getRunes(this.region, new CSA.Long(summonerIds), this.apiKey));
    }

    private static interface Interface {
        @GET(value="/api/lol/{region}/v1.4/summoner/by-name/{summonerNames}")
        public Call<Map<String, SummonerDto>> getByNames(@Path(value="region") Region var1, @Path(value="summonerNames") CSA<String> var2, @Query(value="api_key") ApiKey var3);

        @GET(value="/api/lol/{region}/v1.4/summoner/{summonerIds}")
        public Call<Map<String, SummonerDto>> getByIds(@Path(value="region") Region var1, @Path(value="summonerIds") CSA.Long var2, @Query(value="api_key") ApiKey var3);

        @GET(value="/api/lol/{region}/v1.4/summoner/by-account/{accountIds}")
        public Call<Map<String, SummonerDto>> getByAccounts(@Path(value="region") Region var1, @Path(value="summonerIds") CSA.Long var2, @Query(value="api_key") ApiKey var3);

        @GET(value="/api/lol/{region}/v1.4/summoner/{summonerIds}/masteries")
        public Call<Map<String, MasteryPagesDto>> getMasteries(@Path(value="region") Region var1, @Path(value="summonerIds") CSA.Long var2, @Query(value="api_key") ApiKey var3);

        @GET(value="/api/lol/{region}/v1.4/summoner/{summonerIds}/name")
        public Call<Map<String, String>> getNames(@Path(value="region") Region var1, @Path(value="summonerIds") CSA.Long var2, @Query(value="api_key") ApiKey var3);

        @GET(value="/api/lol/{region}/v1.4/summoner/{summonerIds}/runes")
        public Call<Map<String, RunePagesDto>> getRunes(@Path(value="region") Region var1, @Path(value="summonerIds") CSA.Long var2, @Query(value="api_key") ApiKey var3);
    }
}

