/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.net.Proxy;
import org.dc.riot.lol.rx.model.common.Mastery;
import org.dc.riot.lol.rx.model.common.Rune;
import org.dc.riot.lol.rx.model.staticdata.RangeDto;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.RiotApi;
import org.dc.riot.lol.rx.service.error.InvalidVersionException;
import org.dc.riot.lol.rx.service.interfaces.ChampionMastery_v1_0;
import org.dc.riot.lol.rx.service.interfaces.Champion_v1_2;
import org.dc.riot.lol.rx.service.interfaces.CurrentGame_v1_0;
import org.dc.riot.lol.rx.service.interfaces.FeaturedGames_v1_0;
import org.dc.riot.lol.rx.service.interfaces.League_v2_5;
import org.dc.riot.lol.rx.service.interfaces.LolStatus_v1_0;
import org.dc.riot.lol.rx.service.interfaces.MatchList_v2_2;
import org.dc.riot.lol.rx.service.interfaces.Match_v2_2;
import org.dc.riot.lol.rx.service.interfaces.RecentGames_v1_3;
import org.dc.riot.lol.rx.service.interfaces.StaticData_v1_2;
import org.dc.riot.lol.rx.service.interfaces.Stats_v1_3;
import org.dc.riot.lol.rx.service.interfaces.Summoner_v1_4;
import org.dc.riot.lol.rx.service.interfaces.Team_v2_4;

public final class ApiFactory {
    private static Gson GSON = null;
    private float champVersion;
    private float championMasteryVersion;
    private float currentGameVersion;
    private float featuredGamesVersion;
    private float recentGamesVersion;
    private float leagueVersion;
    private float staticDataVersion;
    private float statsVersion;
    private float statusVersion;
    private float matchVersion;
    private float matchlistVersion;
    private float summonerVersion;
    private float teamVersion;
    private Proxy proxy;
    private boolean autoRetry;
    private int retryCount;
    private final ApiKey apiKey;

    public static Gson getGson() {
        return GSON;
    }

    public static ApiFactory newDefaultFactory(ApiKey apiKey) {
        return new Builder(apiKey).build();
    }

    private ApiFactory(ApiKey apiKey) {
        this.apiKey = apiKey;
    }

    public RiotApi.Champion newChampionInterface(Region region, boolean autoRateControl) {
        Champion_v1_2 api = null;
        if (!((double)this.champVersion >= 1.2)) {
            throw new InvalidVersionException("Lowest supported Champion version is 1.2");
        }
        api = new Champion_v1_2(this.apiKey, region);
        this.completeBuild(RiotApi.Champion.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.ChampionMastery newChampionMasteryInterface(Region region, boolean autoRateControl) {
        ChampionMastery_v1_0 api = null;
        if (!((double)this.championMasteryVersion >= 1.0)) {
            throw new InvalidVersionException("Lowest supported ChampionMastery version is 1.0");
        }
        api = new ChampionMastery_v1_0(this.apiKey, region);
        this.completeBuild(RiotApi.ChampionMastery.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.CurrentGame newCurrentGameInterface(Region region, boolean autoRateControl) {
        CurrentGame_v1_0 api = null;
        if (!(this.currentGameVersion >= 1.0f)) {
            throw new InvalidVersionException("Lowest supported CurrentGame version is 1.0");
        }
        api = new CurrentGame_v1_0(this.apiKey, region);
        this.completeBuild(RiotApi.CurrentGame.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.FeaturedGames newFeaturedGamesInterface(Region region, boolean autoRateControl) {
        FeaturedGames_v1_0 api = null;
        if (!(this.featuredGamesVersion >= 1.0f)) {
            throw new InvalidVersionException("Lowest supported FeaturedGames version is 1.0");
        }
        api = new FeaturedGames_v1_0(this.apiKey, region);
        this.completeBuild(RiotApi.FeaturedGames.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.RecentGames newRecentGamesInterface(Region region, boolean autoRateControl) {
        RecentGames_v1_3 api = null;
        if (!(this.recentGamesVersion >= 1.3f)) {
            throw new InvalidVersionException("Lowest supported RecentGames version is 1.3");
        }
        api = new RecentGames_v1_3(this.apiKey, region);
        this.completeBuild(RiotApi.RecentGames.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.League newLeagueInterface(Region region, boolean autoRateControl) {
        League_v2_5 api = null;
        if (!((double)this.leagueVersion >= 2.5)) {
            throw new InvalidVersionException("Lowest supported League version is 2.5");
        }
        api = new League_v2_5(this.apiKey, region);
        this.completeBuild(RiotApi.League.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.StaticData newStaticDataInterface(Region region, boolean autoRateControl) {
        StaticData_v1_2 api = null;
        if (!((double)this.staticDataVersion >= 1.2)) {
            throw new InvalidVersionException("Lowest supported StaticData version is 1.2");
        }
        api = new StaticData_v1_2(this.apiKey, region);
        this.completeBuild(RiotApi.StaticData.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.Stats newStatsInterface(Region region, boolean autoRateControl) {
        Stats_v1_3 api = null;
        if (!(this.statsVersion >= 1.3f)) {
            throw new InvalidVersionException("Lowest supported StaticData version is 1.3");
        }
        api = new Stats_v1_3(this.apiKey, region);
        this.completeBuild(RiotApi.Stats.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.LolStatus newStatusInterface(Region region, boolean autoRateControl) {
        LolStatus_v1_0 api = null;
        if (!(this.statusVersion >= 1.0f)) {
            throw new InvalidVersionException("Lowest supported LolStatus version is 1.0");
        }
        api = new LolStatus_v1_0(this.apiKey, region);
        this.completeBuild(RiotApi.LolStatus.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.Match newMatchInterface(Region region, boolean autoRateControl) {
        Match_v2_2 api = null;
        if (!(this.matchVersion >= 2.2f)) {
            throw new InvalidVersionException("Lowest supported Match version is 2.2");
        }
        api = new Match_v2_2(this.apiKey, region);
        this.completeBuild(RiotApi.Match.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.MatchList newMatchListInterface(Region region, boolean autoRateControl) {
        MatchList_v2_2 api = null;
        if (!((double)this.matchlistVersion >= 2.2)) {
            throw new InvalidVersionException("Lowest supported MatchListDto version is 2.2");
        }
        api = new MatchList_v2_2(this.apiKey, region);
        this.completeBuild(RiotApi.MatchList.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.Summoner newSummonerInterface(Region region, boolean autoRateControl) {
        Summoner_v1_4 api = null;
        if (!(this.summonerVersion >= 1.4f)) {
            throw new InvalidVersionException("Lowest supported Summoner version is 1.4");
        }
        api = new Summoner_v1_4(this.apiKey, region);
        this.completeBuild(RiotApi.Summoner.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    public RiotApi.Team newTeamInterface(Region region, boolean autoRateControl) {
        Team_v2_4 api = null;
        if (!(this.teamVersion >= 2.4f)) {
            throw new InvalidVersionException("Lowest supported Team version is 2.4");
        }
        api = new Team_v2_4(this.apiKey, region);
        this.completeBuild(RiotApi.Team.getSupportedRegions(api.getVersion()), region, api, autoRateControl);
        return api;
    }

    private void completeBuild(Region[] supportedRegions, Region region, RiotApi api, boolean autoRateControl) {
        boolean supported = false;
        for (Region r : supportedRegions) {
            if (r != region) continue;
            supported = true;
            break;
        }
        if (!supported) {
            throw new IllegalArgumentException("The API " + api.getClass().getSimpleName() + " is not supported for region " + region);
        }
        if (autoRateControl && api.getRateType() == RiotApi.RateType.PERSONAL) {
            api.setRateControl(true);
        }
        api.setAutoRetry(this.autoRetry);
        api.setRetryCount(this.retryCount);
        api.setProxy(this.proxy);
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(RangeDto.class, (Object)new JsonDeserializer<RangeDto>(){

            public RangeDto deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                String rString = json.toString().replace("\"", "");
                int[] ranges = null;
                if (!"self".equalsIgnoreCase(rString)) {
                    JsonArray jRanges = json.getAsJsonArray();
                    int index = 0;
                    ranges = new int[jRanges.size()];
                    for (JsonElement o : jRanges) {
                        ranges[index] = o.getAsInt();
                        ++index;
                    }
                }
                return new RangeDto(ranges);
            }
        });
        builder.registerTypeAdapter(Mastery.class, (Object)new JsonDeserializer<Mastery>(){

            public Mastery deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                Mastery dto = new Mastery();
                JsonObject jsonObject = json.getAsJsonObject();
                int rank = jsonObject.get("rank").getAsInt();
                dto.setRank(rank);
                long id = jsonObject.get("id") != null ? jsonObject.get("id").getAsLong() : jsonObject.get("masteryId").getAsLong();
                dto.setMasteryId(id);
                return dto;
            }
        });
        builder.registerTypeAdapter(Rune.class, (Object)new JsonDeserializer<Rune>(){

            public Rune deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                Rune dto = new Rune();
                JsonObject jsonObject = json.getAsJsonObject();
                long runeId = jsonObject.get("runeId").getAsLong();
                dto.setRuneId(runeId);
                int rank = jsonObject.get("count") != null ? jsonObject.get("count").getAsInt() : jsonObject.get("rank").getAsInt();
                dto.setCount(rank);
                return dto;
            }
        });
        builder.registerTypeAdapter(Region.class, (Object)new JsonDeserializer<Region>(){

            public Region deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                String regionCode = json.getAsString();
                return Region.from(regionCode);
            }
        });
        GSON = builder.create();
    }

    public static class Builder {
        private float champVersion = 1.2f;
        private float championMasteryVersion = 1.0f;
        private float currentGameVersion = 1.0f;
        private float featuredGamesVersion = 1.0f;
        private float recentGamesVersion = 1.3f;
        private float leagueVersion = 2.5f;
        private float statsVersion = 1.3f;
        private float staticDataVersion = 1.2f;
        private float statusVersion = 1.0f;
        private float matchVersion = 2.2f;
        private float matchlistVersion = 2.2f;
        private float summonerVersion = 1.4f;
        private float teamVersion = 2.4f;
        private boolean autoRetry = true;
        private int retryCount = 5;
        private Proxy proxy = null;
        private final ApiKey apiKey;

        public Builder(ApiKey apiKey) {
            this.apiKey = apiKey;
        }

        public Builder setChampionVersion(float champVersion) {
            this.champVersion = champVersion;
            return this;
        }

        public Builder setChampionMasteryVersion(float championMasteryVersion) {
            this.championMasteryVersion = championMasteryVersion;
            return this;
        }

        public Builder setCurrentGameVersion(float currentGameVersion) {
            this.currentGameVersion = currentGameVersion;
            return this;
        }

        public Builder setFeaturedGamesVersion(float featuredGamesVersion) {
            this.featuredGamesVersion = featuredGamesVersion;
            return this;
        }

        public Builder setRecentGamesVersion(float recentGamesVersion) {
            this.recentGamesVersion = recentGamesVersion;
            return this;
        }

        public Builder setLeagueVersion(float leagueVersion) {
            this.leagueVersion = leagueVersion;
            return this;
        }

        public Builder setStaticDataVersion(float staticDataVersion) {
            this.staticDataVersion = staticDataVersion;
            return this;
        }

        public Builder setStatsVersion(float statsVersion) {
            this.statsVersion = statsVersion;
            return this;
        }

        public Builder setStatusVersion(float statusVersion) {
            this.statusVersion = statusVersion;
            return this;
        }

        public Builder setMatchVersion(float matchVersion) {
            this.matchVersion = matchVersion;
            return this;
        }

        public Builder setMatchListVersion(float matchlistVersion) {
            this.matchlistVersion = matchlistVersion;
            return this;
        }

        public Builder setSummonerVersion(float summonerVersion) {
            this.summonerVersion = summonerVersion;
            return this;
        }

        public Builder setTeamVersion(float teamVersion) {
            this.teamVersion = teamVersion;
            return this;
        }

        public Builder setProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder setAutoRetry(boolean autoRetry) {
            this.autoRetry = autoRetry;
            return this;
        }

        public Builder setRetyCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public ApiFactory build() {
            ApiFactory factory = new ApiFactory(this.apiKey);
            factory.champVersion = this.champVersion;
            factory.championMasteryVersion = this.championMasteryVersion;
            factory.currentGameVersion = this.currentGameVersion;
            factory.featuredGamesVersion = this.featuredGamesVersion;
            factory.recentGamesVersion = this.recentGamesVersion;
            factory.leagueVersion = this.leagueVersion;
            factory.staticDataVersion = this.staticDataVersion;
            factory.statsVersion = this.statsVersion;
            factory.statusVersion = this.statusVersion;
            factory.matchVersion = this.matchVersion;
            factory.matchlistVersion = this.matchlistVersion;
            factory.summonerVersion = this.summonerVersion;
            factory.teamVersion = this.teamVersion;
            factory.proxy = this.proxy;
            factory.autoRetry = this.autoRetry;
            factory.retryCount = this.retryCount;
            return factory;
        }
    }
}

