/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Map;
import org.dc.riot.lol.rx.model.team.TeamDto;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.RiotApi;
import org.dc.riot.lol.rx.service.error.HttpException;
import org.dc.riot.lol.rx.service.interfaces.ApiFactory;
import org.dc.riot.lol.rx.service.interfaces.CSA;
import org.dc.riot.lol.rx.service.interfaces.LowercaseRegion;
import org.dc.riot.lol.rx.service.interfaces.RetrofitCaller;
import org.dc.riot.lol.rx.service.interfaces.RiotApiBase;
import retrofit.Call;
import retrofit.Converter;
import retrofit.GsonConverterFactory;
import retrofit.Retrofit;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;

class Team_v2_4
extends RiotApiBase
implements RiotApi.Team {
    private Interface inter;

    public Team_v2_4(ApiKey apiKey, Region region) {
        super(apiKey, region);
        Retrofit ra = new Retrofit.Builder().baseUrl("https://" + region.toString().toLowerCase() + ".api.pvp.net").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)ApiFactory.getGson())).client(this.client).build();
        this.inter = (Interface)ra.create(Interface.class);
    }

    @Override
    public float getVersion() {
        return 2.4f;
    }

    @Override
    public Map<String, TeamDto[]> getTeamsBySummoners(long ... summonerIds) throws IOException, HttpException {
        return (Map)RetrofitCaller.processCall(() -> this.inter.getTeamsBySummoners(new LowercaseRegion(this.region), new CSA.Long(summonerIds), this.apiKey));
    }

    @Override
    public Map<String, TeamDto> getTeams(String ... teamIds) throws IOException, HttpException {
        return (Map)RetrofitCaller.processCall(() -> this.inter.getTeams(new LowercaseRegion(this.region), new CSA<String>(teamIds), this.apiKey));
    }

    private static interface Interface {
        @GET(value="/api/lol/{region}/v2.4/team/by-summoner/{summonerIds}")
        public Call<Map<String, TeamDto[]>> getTeamsBySummoners(@Path(value="region") LowercaseRegion var1, @Path(value="summonerIds") CSA.Long var2, @Query(value="api_key") ApiKey var3);

        @GET(value="/api/lol/{region}/v2.4/team/by-summoner/{teamIds}")
        public Call<Map<String, TeamDto>> getTeams(@Path(value="region") LowercaseRegion var1, @Path(value="teamIds") CSA<String> var2, @Query(value="api_key") ApiKey var3);
    }
}

