/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.model.match;

import org.dc.riot.lol.rx.model.common.MatchMode;
import org.dc.riot.lol.rx.model.common.MatchType;
import org.dc.riot.lol.rx.model.common.PlatformId;
import org.dc.riot.lol.rx.model.common.QueueType;
import org.dc.riot.lol.rx.model.common.Season;
import org.dc.riot.lol.rx.model.match.Participant;
import org.dc.riot.lol.rx.model.match.ParticipantIdentity;
import org.dc.riot.lol.rx.model.match.Team;
import org.dc.riot.lol.rx.model.match.Timeline;
import org.dc.riot.lol.rx.service.Region;

public class MatchDetail {
    private static long COUNT = 0L;
    private Integer mapId;
    private Long matchCreation;
    private Long matchDuration;
    private Long matchId;
    private MatchMode matchMode;
    private MatchType matchType;
    private String matchVersion;
    private ParticipantIdentity[] participantIdentities;
    private Participant[] participants;
    private PlatformId platformId;
    private QueueType queueType;
    private Region region;
    private Season season;
    private Team[] teams;
    private Timeline timeline;

    public static long getInstanceCount() {
        return COUNT;
    }

    public MatchDetail() {
        ++COUNT;
    }

    public int getMapId() {
        if (this.mapId == null) {
            return -1;
        }
        return this.mapId;
    }

    public long getMatchCreation() {
        if (this.matchCreation == null) {
            return this.matchCreation;
        }
        return this.matchCreation;
    }

    public long getMatchDuration() {
        if (this.matchDuration == null) {
            return -1L;
        }
        return this.matchDuration;
    }

    public long getMatchId() {
        if (this.matchId == null) {
            return -1L;
        }
        return this.matchId;
    }

    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public String getMatchVersion() {
        return this.matchVersion;
    }

    public ParticipantIdentity[] getParticipantIdentities() {
        return this.participantIdentities;
    }

    public Participant[] getParticipants() {
        if (this.participants == null) {
            return new Participant[0];
        }
        return this.participants;
    }

    public PlatformId getPlatformId() {
        return this.platformId;
    }

    public QueueType getQueueType() {
        return this.queueType;
    }

    public Region getRegion() {
        if (this.region == null && this.platformId != null) {
            return this.platformId.toRegion();
        }
        return this.region;
    }

    public Season getSeason() {
        return this.season;
    }

    public Team[] getTeams() {
        return this.teams;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public ParticipantIdentity getParticipantIdentity(Participant participant) {
        if (this.participantIdentities != null) {
            for (ParticipantIdentity participantIdentity : this.participantIdentities) {
                if (participant.getParticipantId() != participantIdentity.getParticipantId()) continue;
                return participantIdentity;
            }
        }
        return null;
    }

    public Participant getParticipant(ParticipantIdentity participantIdentity) {
        if (this.participants != null) {
            for (Participant participant : this.participants) {
                if (participant.getParticipantId() != participantIdentity.getParticipantId()) continue;
                return participant;
            }
        }
        return null;
    }
}

