/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service;

import java.util.Arrays;
import java.util.HashSet;
import org.dc.riot.lol.rx.service.Region;

public class Regions {
    private static final Region[] REGIONS = new Region[]{new Region("North America", "NA"), new Region("Europe West", "EUW"), new Region("Europe Northeast", "EUNE"), new Region("Latin America North", "LAN"), new Region("Latin America South", "LAS"), new Region("Brazil", "BR"), new Region("Korea", "KR"), new Region("Oceanic", "OCE"), new Region("Russia", "RU"), new Region("Turkey", "TR"), new Region("Public Beta Environment", "PBE")};

    public static Region[] getRegions() {
        Region[] regions = new Region[REGIONS.length];
        System.arraycopy(REGIONS, 0, regions, 0, regions.length);
        return regions;
    }

    public static Region getByCode(String code) {
        for (Region r : REGIONS) {
            if (!r.getCode().equals(code)) continue;
            return r;
        }
        return null;
    }

    public static Region[] getExcluding(Region ... excludedRegions) {
        Region[] regions = Regions.getRegions();
        if (excludedRegions == null || excludedRegions.length == 0) {
            return regions;
        }
        excludedRegions = Regions.removeDuplicates(excludedRegions);
        int excludedLength = 0;
        for (Region r : excludedRegions) {
            if (r == null) continue;
            ++excludedLength;
        }
        int outputLength = regions.length - excludedLength;
        if (outputLength < 1) {
            return new Region[0];
        }
        Region[] outputRegions = new Region[outputLength];
        int i = 0;
        for (Region r : regions) {
            boolean excluded;
            boolean bl = excluded = r == null || Regions.contains(excludedRegions, r);
            if (excluded) continue;
            outputRegions[i] = r;
            ++i;
        }
        return outputRegions;
    }

    private static Region[] removeDuplicates(Region[] regions) {
        HashSet<Region> alreadyPresent = new HashSet<Region>();
        Region[] whitelist = new Region[regions.length];
        int i = 0;
        for (Region r : regions) {
            if (!alreadyPresent.add(r)) continue;
            whitelist[i++] = r;
        }
        return Arrays.copyOf(whitelist, i);
    }

    private static boolean contains(Region[] regions, Region r) {
        for (Region re : regions) {
            if (!re.equals(r)) continue;
            return true;
        }
        return false;
    }
}

