/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service;

import java.io.IOException;
import java.net.Proxy;
import java.util.Map;
import org.dc.riot.lol.rx.model.champion.ChampDto;
import org.dc.riot.lol.rx.model.champion.ChampListDto;
import org.dc.riot.lol.rx.model.championmastery.ChampionMasteryDto;
import org.dc.riot.lol.rx.model.common.QueueType;
import org.dc.riot.lol.rx.model.common.RankedQueue;
import org.dc.riot.lol.rx.model.common.Season;
import org.dc.riot.lol.rx.model.currentgame.CurrentGameInfo;
import org.dc.riot.lol.rx.model.featuredgame.FeaturedGamesDto;
import org.dc.riot.lol.rx.model.game.RecentGamesDto;
import org.dc.riot.lol.rx.model.league.LeagueDto;
import org.dc.riot.lol.rx.model.match.MatchDetail;
import org.dc.riot.lol.rx.model.match.MatchListDto;
import org.dc.riot.lol.rx.model.staticdata.ChampionDto;
import org.dc.riot.lol.rx.model.staticdata.ChampionListDto;
import org.dc.riot.lol.rx.model.staticdata.ItemDto;
import org.dc.riot.lol.rx.model.staticdata.ItemListDto;
import org.dc.riot.lol.rx.model.staticdata.LanguageStringsDto;
import org.dc.riot.lol.rx.model.staticdata.MapDataDto;
import org.dc.riot.lol.rx.model.staticdata.MasteryDto;
import org.dc.riot.lol.rx.model.staticdata.MasteryListDto;
import org.dc.riot.lol.rx.model.staticdata.RealmDto;
import org.dc.riot.lol.rx.model.staticdata.RuneDto;
import org.dc.riot.lol.rx.model.staticdata.RuneListDto;
import org.dc.riot.lol.rx.model.staticdata.SummonerSpellDto;
import org.dc.riot.lol.rx.model.staticdata.SummonerSpellListDto;
import org.dc.riot.lol.rx.model.stats.PlayerStatsSummaryListDto;
import org.dc.riot.lol.rx.model.stats.RankedStatsDto;
import org.dc.riot.lol.rx.model.status.Shard;
import org.dc.riot.lol.rx.model.status.ShardStatus;
import org.dc.riot.lol.rx.model.summoner.MasteryPagesDto;
import org.dc.riot.lol.rx.model.summoner.RunePagesDto;
import org.dc.riot.lol.rx.model.summoner.SummonerDto;
import org.dc.riot.lol.rx.model.team.TeamDto;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.Regions;
import org.dc.riot.lol.rx.service.error.HttpException;
import org.dc.riot.lol.rx.service.error.InvalidVersionException;
import org.dc.riot.lol.rx.service.request.ChampDataTag;
import org.dc.riot.lol.rx.service.request.ChampListDataTag;
import org.dc.riot.lol.rx.service.request.ItemDataTag;
import org.dc.riot.lol.rx.service.request.ItemListDataTag;
import org.dc.riot.lol.rx.service.request.MasteryDataTag;
import org.dc.riot.lol.rx.service.request.MasteryListDataTag;
import org.dc.riot.lol.rx.service.request.RuneDataTag;
import org.dc.riot.lol.rx.service.request.RuneListDataTag;
import org.dc.riot.lol.rx.service.request.SpellDataTag;

public interface RiotApi {
    default public RateType getRateType() {
        return RateType.PERSONAL;
    }

    public Region getRegion();

    public ApiKey getApiKey();

    public float getVersion();

    public void setRateControl(boolean var1);

    public void setProxy(Proxy var1);

    public void setAutoRetry(boolean var1);

    public void setRetryCount(int var1);

    public void setPrintUrl(boolean var1);

    public static interface Team
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if (version >= 2.4f) {
                return Regions.getExcluding(Regions.getByCode("PBE"));
            }
            throw new InvalidVersionException();
        }

        public Map<String, TeamDto[]> getTeamsBySummoners(long ... var1) throws IOException, HttpException;

        public Map<String, TeamDto> getTeams(String ... var1) throws IOException, HttpException;
    }

    public static interface Summoner
    extends RiotApi {
        public static String encodeName(String name) {
            return name.toLowerCase().replace(" ", "").trim();
        }

        public static Region[] getSupportedRegions(float version) {
            if (version >= 1.4f) {
                return Regions.getExcluding(Regions.getByCode("PBE"));
            }
            throw new InvalidVersionException();
        }

        public Map<String, SummonerDto> getByNames(String ... var1) throws IOException, HttpException;

        public Map<String, SummonerDto> getByAccounts(long ... var1) throws IOException, HttpException;

        public Map<String, SummonerDto> getByIds(long ... var1) throws IOException, HttpException;

        public Map<String, MasteryPagesDto> getMasteries(long ... var1) throws IOException, HttpException;

        public Map<String, String> getNames(long ... var1) throws IOException, HttpException;

        public Map<String, RunePagesDto> getRunes(long ... var1) throws IOException, HttpException;
    }

    public static interface Stats
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if (version >= 1.3f) {
                return Regions.getExcluding(Regions.getByCode("PBE"));
            }
            throw new InvalidVersionException();
        }

        public RankedStatsDto getRanked(long var1, Season var3) throws IOException, HttpException;

        public PlayerStatsSummaryListDto getSummary(long var1, Season var3) throws IOException, HttpException;
    }

    public static interface MatchList
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if (version >= 2.2f) {
                return Regions.getExcluding(Regions.getByCode("PBE"));
            }
            throw new InvalidVersionException();
        }

        public MatchListDto getMatchList(long var1, long[] var3, RankedQueue[] var4, Season[] var5, long var6, long var8, int var10, int var11) throws IOException, HttpException;
    }

    public static interface Match
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if (version >= 2.2f) {
                return Regions.getExcluding(Regions.getByCode("PBE"));
            }
            throw new InvalidVersionException();
        }

        public MatchDetail getMatch(long var1, boolean var3) throws IOException, HttpException;
    }

    public static interface LolStatus
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if (version >= 1.0f) {
                return Regions.getExcluding(Regions.getByCode("KR"));
            }
            throw new InvalidVersionException();
        }

        public Shard[] getShards() throws IOException, HttpException;

        public ShardStatus getShard() throws IOException, HttpException;
    }

    public static interface StaticData
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if (version >= 1.2f) {
                return Regions.getRegions();
            }
            throw new InvalidVersionException();
        }

        @Override
        default public RateType getRateType() {
            return RateType.SERVICE;
        }

        public ChampionListDto getChampions(boolean var1, String var2, String var3, ChampListDataTag ... var4) throws IOException, HttpException;

        public ChampionDto getChampion(long var1, String var3, String var4, ChampDataTag ... var5) throws IOException, HttpException;

        public ItemListDto getItems(String var1, String var2, ItemListDataTag ... var3) throws IOException, HttpException;

        public ItemDto getItem(long var1, String var3, String var4, ItemDataTag ... var5) throws IOException, HttpException;

        public LanguageStringsDto getLanguageStrings(String var1, String var2) throws IOException, HttpException;

        public String[] getLocales() throws IOException, HttpException;

        public MapDataDto getMap(String var1, String var2) throws IOException, HttpException;

        public MasteryListDto getMasteries(String var1, String var2, MasteryListDataTag ... var3) throws IOException, HttpException;

        public MasteryDto getMastery(long var1, String var3, String var4, MasteryDataTag ... var5) throws IOException, HttpException;

        public RealmDto getRealm() throws IOException, HttpException;

        public RuneListDto getRunes(String var1, String var2, RuneListDataTag ... var3) throws IOException, HttpException;

        public RuneDto getRune(long var1, String var3, String var4, RuneDataTag ... var5) throws IOException, HttpException;

        public SummonerSpellListDto getSummonerSpells(boolean var1, String var2, String var3, SpellDataTag ... var4) throws IOException, HttpException;

        public SummonerSpellDto getSummonerSpell(long var1, String var3, String var4, SpellDataTag ... var5) throws IOException, HttpException;

        public String[] getVersions() throws IOException, HttpException;
    }

    public static interface League
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if (version >= 2.5f) {
                return Regions.getExcluding(Regions.getByCode("PBE"));
            }
            throw new InvalidVersionException();
        }

        public Map<String, LeagueDto[]> getBySummonerEntries(long ... var1) throws IOException, HttpException;

        public Map<String, LeagueDto[]> getBySummoners(long ... var1) throws IOException, HttpException;

        public Map<String, LeagueDto[]> getByTeams(String ... var1) throws IOException, HttpException;

        public Map<String, LeagueDto[]> getByTeamEntries(String ... var1) throws IOException, HttpException;

        public LeagueDto getChallenger(QueueType.ChallengerMaster var1) throws IOException, HttpException;

        public LeagueDto getMaster(QueueType.ChallengerMaster var1) throws IOException, HttpException;
    }

    public static interface RecentGames
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if (version >= 1.3f) {
                return Regions.getExcluding(Regions.getByCode("PBE"));
            }
            throw new InvalidVersionException();
        }

        public RecentGamesDto getRecentGames(long var1) throws IOException, HttpException;
    }

    public static interface FeaturedGames
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if (version >= 1.0f) {
                return Regions.getRegions();
            }
            throw new InvalidVersionException();
        }

        public FeaturedGamesDto getFeaturedGames() throws IOException, HttpException;
    }

    public static interface CurrentGame
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if (version >= 1.0f) {
                return Regions.getRegions();
            }
            throw new InvalidVersionException();
        }

        public CurrentGameInfo getSpectatorInfo(long var1) throws IOException, HttpException;
    }

    public static interface ChampionMastery
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if ((double)version >= 1.0) {
                return Regions.getExcluding(Regions.getByCode("PBE"));
            }
            throw new InvalidVersionException();
        }

        public ChampionMasteryDto getPlayerChampionMastery(long var1, long var3) throws IOException, HttpException;

        public ChampionMasteryDto[] getPlayerAllMastery(long var1) throws IOException, HttpException;

        public int getMasteryScore(long var1) throws IOException, HttpException;

        public ChampionMasteryDto[] getTopChampions(long var1, int var3) throws IOException, HttpException;
    }

    public static interface Champion
    extends RiotApi {
        public static Region[] getSupportedRegions(float version) {
            if (version >= 1.2f) {
                return Regions.getExcluding(Regions.getByCode("PBE"));
            }
            throw new InvalidVersionException();
        }

        public ChampListDto getChampions(boolean var1) throws IOException, HttpException;

        public ChampDto getChampion(long var1) throws IOException, HttpException;
    }

    public static enum RateType {
        PERSONAL("user"),
        SERVICE("service");

        private final String text;

        private RateType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static RateType from(String s) {
            for (RateType t : RateType.values()) {
                if (!t.text.equals(s)) continue;
                return t;
            }
            return null;
        }
    }
}

