/*
 * Decompiled with CFR 0.152.
 */
package org.dc.riot.lol.rx.service.interfaces;

import com.google.gson.Gson;
import java.io.IOException;
import org.dc.riot.lol.rx.model.common.Season;
import org.dc.riot.lol.rx.model.stats.PlayerStatsSummaryListDto;
import org.dc.riot.lol.rx.model.stats.RankedStatsDto;
import org.dc.riot.lol.rx.service.ApiKey;
import org.dc.riot.lol.rx.service.Region;
import org.dc.riot.lol.rx.service.RiotApi;
import org.dc.riot.lol.rx.service.error.HttpException;
import org.dc.riot.lol.rx.service.interfaces.ApiFactory;
import org.dc.riot.lol.rx.service.interfaces.LowercaseRegion;
import org.dc.riot.lol.rx.service.interfaces.RetrofitCaller;
import org.dc.riot.lol.rx.service.interfaces.RiotApiBase;
import retrofit.Call;
import retrofit.Converter;
import retrofit.GsonConverterFactory;
import retrofit.Retrofit;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;

class Stats_v1_3
extends RiotApiBase
implements RiotApi.Stats {
    private Interface inter;

    Stats_v1_3(ApiKey apiKey, Region region) {
        super(apiKey, region);
        Retrofit ra = new Retrofit.Builder().baseUrl("https://" + new LowercaseRegion(region) + ".api.pvp.net").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)ApiFactory.getGson())).client(this.client).build();
        this.inter = (Interface)ra.create(Interface.class);
    }

    @Override
    public float getVersion() {
        return 1.3f;
    }

    @Override
    public RankedStatsDto getRanked(long summonerId, Season season) throws IOException, HttpException {
        RankedStatsDto noRanked = new RankedStatsDto();
        return RetrofitCaller.processCall(() -> this.inter.getRanked(new LowercaseRegion(this.region), summonerId, season, this.apiKey), noRanked, 404);
    }

    @Override
    public PlayerStatsSummaryListDto getSummary(long summonerId, Season season) throws IOException, HttpException {
        return (PlayerStatsSummaryListDto)RetrofitCaller.processCall(() -> this.inter.getSummary(new LowercaseRegion(this.region), summonerId, season, this.apiKey));
    }

    private static interface Interface {
        @GET(value="/api/lol/{region}/v1.3/stats/by-summoner/{summonerId}/ranked")
        public Call<RankedStatsDto> getRanked(@Path(value="region") LowercaseRegion var1, @Path(value="summonerId") long var2, @Query(value="season") Season var4, @Query(value="api_key") ApiKey var5);

        @GET(value="/api/lol/{region}/v1.3/stats/by-summoner/{summonerId}/summary")
        public Call<PlayerStatsSummaryListDto> getSummary(@Path(value="region") LowercaseRegion var1, @Path(value="summonerId") long var2, @Query(value="season") Season var4, @Query(value="api_key") ApiKey var5);
    }
}

