/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.toolkit.persistence.component;

import com.github.developframework.toolkit.persistence.component.CustomDateRange;
import com.github.developframework.toolkit.persistence.component.DateRange;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Component
public class DateRangeArgumentResolver
implements HandlerMethodArgumentResolver {
    private String startKey;
    private String endKey;
    private String pattern;

    public DateRangeArgumentResolver() {
        this.pattern = "yyyy-MM-dd HH:mm:ss";
        this.startKey = "start_date";
        this.endKey = "end_date";
    }

    public DateRangeArgumentResolver(String pattern, String startKey, String endKey) {
        this.pattern = pattern;
        this.startKey = startKey;
        this.endKey = endKey;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        return DateRange.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory binderFactory) throws Exception {
        String sk = null;
        String ek = null;
        String p = null;
        if (parameter.hasParameterAnnotation(CustomDateRange.class)) {
            CustomDateRange customDateRangeAnnotation = (CustomDateRange)parameter.getMethodAnnotation(CustomDateRange.class);
            sk = customDateRangeAnnotation.startKey();
            ek = customDateRangeAnnotation.endKey();
            p = customDateRangeAnnotation.value();
        }
        String startDateStr = nativeWebRequest.getParameter(sk != null ? sk : this.startKey);
        String endDateStr = nativeWebRequest.getParameter(ek != null ? ek : this.endKey);
        return DateRange.parse(startDateStr, endDateStr, p != null ? p : this.pattern);
    }

    public String getStartKey() {
        return this.startKey;
    }

    public String getEndKey() {
        return this.endKey;
    }

    public String getPattern() {
        return this.pattern;
    }
}

