/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.toolkit.persistence.component;

import com.github.developframework.toolkit.persistence.component.Pager;
import java.lang.reflect.Constructor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Component
public class PagerArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(PagerArgumentResolver.class);
    private String indexKey;
    private String sizeKey;
    private Class<? extends Pager> pagerClass;

    public PagerArgumentResolver(Class<? extends Pager> pagerClass) {
        log.info("Application loaded PagerArgumentResolver.");
        this.indexKey = "index";
        this.sizeKey = "size";
        this.pagerClass = pagerClass;
    }

    public PagerArgumentResolver(Class<? extends Pager> pagerClass, String indexKey, String sizeKey) {
        log.info("Application loaded PagerArgumentResolver.");
        this.indexKey = indexKey;
        this.sizeKey = sizeKey;
        this.pagerClass = pagerClass;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        return this.pagerClass.isAssignableFrom(methodParameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        String pi = nativeWebRequest.getParameter(this.indexKey);
        String ps = nativeWebRequest.getParameter(this.sizeKey);
        int index = 1;
        int size = 10;
        if (StringUtils.isNotBlank((CharSequence)pi)) {
            try {
                index = Integer.valueOf(pi);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotBlank((CharSequence)ps)) {
            try {
                size = Integer.valueOf(ps);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Constructor<? extends Pager> constructor = this.pagerClass.getConstructor(Integer.TYPE, Integer.TYPE);
        return constructor.newInstance(index, size);
    }
}

