/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.toolkit.persistence.component;

import com.github.developframework.toolkit.persistence.exception.RangeException;
import java.io.Serializable;

public class Range<Y extends Comparable<? super Y>>
implements Serializable {
    private String fieldName;
    private Y from;
    private Y to;

    public Range(Y from, Y to) {
        this.from = from;
        this.to = to;
        if (from != null && to != null && from.compareTo(to) > 0) {
            throw new RangeException("The \"from\" value must less than or equal to \"to\" value.");
        }
        if (from == null && to == null) {
            throw new RangeException("The \"from\" value and \"to\" value can't be all null.");
        }
    }

    public boolean isBetween() {
        return this.from != null && this.to != null;
    }

    public boolean isOnlyFrom() {
        return this.from != null && this.to == null;
    }

    public boolean isOnlyTo() {
        return this.from == null && this.to != null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Y getFrom() {
        return this.from;
    }

    public Y getTo() {
        return this.to;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setFrom(Y from) {
        this.from = from;
    }

    public void setTo(Y to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        Y this$from = this.getFrom();
        Y other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Y this$to = this.getTo();
        Y other$to = other.getTo();
        return !(this$to == null ? other$to != null : !this$to.equals(other$to));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Range;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        Y $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Y $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        return result;
    }

    public String toString() {
        return "Range(fieldName=" + this.getFieldName() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }

    public Range() {
    }
}

